/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import com.github.fge.lambdas.Throwing;
import jakarta.mail.BodyPart;
import jakarta.mail.Header;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMailet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ICSSanitizer
extends GenericMailet {
    private static final Logger LOGGER = LoggerFactory.getLogger(ICSSanitizer.class);
    private static final int TEXT_PREFIX_SIZE = 5;
    public static final String DEFAULT_FILENAME = "event.ics";

    public void service(Mail mail) {
        try {
            Multipart multipart;
            MimeMessage mimeMessage = mail.getMessage();
            if (mimeMessage.getContent() instanceof Multipart && this.needsSanitizing(multipart = (Multipart)mimeMessage.getContent())) {
                mimeMessage.setContent((Multipart)this.sanitize(multipart));
                mimeMessage.saveChanges();
            }
        }
        catch (Exception e) {
            LOGGER.warn("Could not sanitize {}", (Object)mail.getName(), (Object)e);
        }
    }

    private boolean needsSanitizing(Multipart multipart) throws MessagingException {
        return this.bodyPartStream(multipart).anyMatch((Predicate<BodyPart>)Throwing.predicate(this::needsSanitizing));
    }

    private boolean needsSanitizing(BodyPart bodyPart) throws MessagingException {
        return bodyPart.isMimeType("text/calendar") && bodyPart.getSize() <= 0;
    }

    private MimeMultipart sanitize(Multipart multipart) throws MessagingException {
        MimeMultipart mimeMultipart = new MimeMultipart();
        this.bodyPartStream(multipart).map(Throwing.function(this::sanitize)).forEach(Throwing.consumer(arg_0 -> ((MimeMultipart)mimeMultipart).addBodyPart(arg_0)));
        return mimeMultipart;
    }

    private BodyPart sanitize(BodyPart bodyPart) throws MessagingException {
        if (this.needsSanitizing(bodyPart) && bodyPart instanceof MimeBodyPart) {
            MimeBodyPart mimeBodyPart = (MimeBodyPart)bodyPart;
            mimeBodyPart.setText(this.computeBodyFromOriginalCalendar(bodyPart), StandardCharsets.UTF_8.name(), bodyPart.getContentType().substring(5));
            this.setFileNameIfNeeded(mimeBodyPart);
        }
        return bodyPart;
    }

    private void setFileNameIfNeeded(MimeBodyPart mimeBodyPart) throws MessagingException {
        if (mimeBodyPart.getFileName() == null) {
            mimeBodyPart.setFileName(DEFAULT_FILENAME);
        }
    }

    private String computeBodyFromOriginalCalendar(BodyPart bodyPart) throws MessagingException {
        return this.headerStream(bodyPart).map(header -> header.getName() + ": " + header.getValue()).collect(Collectors.joining("\r\n"));
    }

    private Stream<Header> headerStream(BodyPart bodyPart) throws MessagingException {
        return Collections.list(bodyPart.getAllHeaders()).stream();
    }

    private Stream<BodyPart> bodyPartStream(Multipart multipart) throws MessagingException {
        return IntStream.range(0, multipart.getCount()).boxed().map(Throwing.function(arg_0 -> ((Multipart)multipart).getBodyPart(arg_0)));
    }
}

