/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.memory;

import java.util.HashMap;
import java.util.Map;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.ConstantOperand;
import org.apache.iotdb.db.queryengine.plan.expression.multi.FunctionExpression;

public class LayerMemoryAssigner {
    private final float memoryBudgetInMB;
    private final Map<Expression, Integer> expressionReferenceCount = new HashMap<Expression, Integer>();
    private float memoryBudgetForSingleReference;

    public LayerMemoryAssigner(float memoryBudgetInMB) {
        this.memoryBudgetInMB = memoryBudgetInMB;
    }

    public void increaseExpressionReference(Expression expression) {
        this.expressionReferenceCount.put(expression, this.expressionReferenceCount.containsKey(expression) ? 1 + this.expressionReferenceCount.get(expression) : 1);
    }

    public void build() {
        int memoryPartitions = 0;
        for (Map.Entry<Expression, Integer> expressionReferenceEntry : this.expressionReferenceCount.entrySet()) {
            Expression expression = expressionReferenceEntry.getKey();
            if (expression instanceof FunctionExpression) {
                memoryPartitions += 2;
                continue;
            }
            if (expression instanceof ConstantOperand) continue;
            ++memoryPartitions;
        }
        this.memoryBudgetForSingleReference = memoryPartitions == 0 ? this.memoryBudgetInMB : this.memoryBudgetInMB / (float)memoryPartitions;
    }

    public int getReference(Expression expression) {
        return this.expressionReferenceCount.get(expression);
    }

    public float assign() {
        return this.memoryBudgetForSingleReference;
    }
}

