/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.load;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TTimePartitionSlot;
import org.apache.iotdb.commons.consensus.ConsensusGroupId;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.MinimumProgressIndex;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.apache.iotdb.commons.service.metric.MetricService;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.commons.utils.FileUtils;
import org.apache.iotdb.commons.utils.RetryUtils;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.consensus.DataRegionConsensusImpl;
import org.apache.iotdb.db.exception.DiskSpaceInsufficientException;
import org.apache.iotdb.db.exception.load.LoadFileException;
import org.apache.iotdb.db.pipe.agent.PipeDataNodeAgent;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.load.LoadTsFilePieceNode;
import org.apache.iotdb.db.storageengine.dataregion.DataRegion;
import org.apache.iotdb.db.storageengine.dataregion.flush.MemTableFlushTask;
import org.apache.iotdb.db.storageengine.dataregion.modification.ModificationFile;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResourceStatus;
import org.apache.iotdb.db.storageengine.load.active.ActiveLoadAgent;
import org.apache.iotdb.db.storageengine.load.splitter.ChunkData;
import org.apache.iotdb.db.storageengine.load.splitter.DeletionData;
import org.apache.iotdb.db.storageengine.load.splitter.TsFileData;
import org.apache.iotdb.db.storageengine.rescon.disk.FolderManager;
import org.apache.iotdb.db.storageengine.rescon.disk.strategy.DirectoryStrategyType;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.ChunkGroupMetadata;
import org.apache.tsfile.file.metadata.ChunkMetadata;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.file.metadata.PlainDeviceID;
import org.apache.tsfile.read.TimeValuePair;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.apache.tsfile.utils.TsPrimitiveType;
import org.apache.tsfile.write.writer.TsFileIOWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadTsFileManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoadTsFileManager.class);
    private static final IoTDBConfig CONFIG = IoTDBDescriptor.getInstance().getConfig();
    private static final String MESSAGE_WRITER_MANAGER_HAS_BEEN_CLOSED = "%s TsFileWriterManager has been closed.";
    private static final String MESSAGE_DELETE_FAIL = "failed to delete {}.";
    private static final AtomicReference<String[]> LOAD_BASE_DIRS = new AtomicReference<String[]>(CONFIG.getLoadTsFileDirs());
    private static final AtomicReference<FolderManager> FOLDER_MANAGER = new AtomicReference();
    private final Map<String, TsFileWriterManager> uuid2WriterManager = new ConcurrentHashMap<String, TsFileWriterManager>();
    private final Map<String, CleanupTask> uuid2CleanupTask = new ConcurrentHashMap<String, CleanupTask>();
    private final PriorityBlockingQueue<CleanupTask> cleanupTaskQueue = new PriorityBlockingQueue();
    private final ActiveLoadAgent activeLoadAgent = new ActiveLoadAgent();

    public LoadTsFileManager() {
        this.registerCleanupTaskExecutor();
        this.recover();
        this.activeLoadAgent.start();
    }

    private void registerCleanupTaskExecutor() {
        PipeDataNodeAgent.runtime().registerPeriodicalJob("LoadTsFileManager#cleanupTasks", this::cleanupTasks, CONFIG.getLoadCleanupTaskExecutionDelayTimeSeconds() >> 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupTasks() {
        while (!this.cleanupTaskQueue.isEmpty()) {
            Map<String, CleanupTask> map = this.uuid2CleanupTask;
            synchronized (map) {
                if (this.cleanupTaskQueue.isEmpty()) {
                    continue;
                }
                CleanupTask cleanupTask = this.cleanupTaskQueue.peek();
                if (cleanupTask.scheduledTime <= System.currentTimeMillis()) {
                    if (cleanupTask.isLoadTaskRunning) {
                        this.cleanupTaskQueue.poll();
                        cleanupTask.resetScheduledTime();
                        this.cleanupTaskQueue.add(cleanupTask);
                        continue;
                    }
                } else {
                    long waitTimeInMs = cleanupTask.scheduledTime - System.currentTimeMillis();
                    LOGGER.info("Next load cleanup task {} is not ready to run, wait for at least {} ms ({}s).", new Object[]{cleanupTask.uuid, waitTimeInMs, (double)waitTimeInMs / 1000.0});
                    return;
                }
                cleanupTask.run();
                this.uuid2CleanupTask.remove(cleanupTask.uuid);
                this.cleanupTaskQueue.poll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recover() {
        if (CONFIG.getLoadTsFileDirs() != LOAD_BASE_DIRS.get()) {
            AtomicReference<FolderManager> atomicReference = FOLDER_MANAGER;
            synchronized (atomicReference) {
                if (CONFIG.getLoadTsFileDirs() != LOAD_BASE_DIRS.get()) {
                    LOAD_BASE_DIRS.set(CONFIG.getLoadTsFileDirs());
                }
            }
        }
        File[] baseDirs = (File[])Arrays.stream(LOAD_BASE_DIRS.get()).map(File::new).toArray(File[]::new);
        File[] files = (File[])Arrays.stream(baseDirs).filter(File::exists).flatMap(dir -> {
            File[] listedFiles = dir.listFiles();
            return listedFiles != null ? Arrays.stream(listedFiles) : Stream.empty();
        }).toArray(File[]::new);
        ((Stream)Arrays.stream(files).parallel()).forEach(taskDir -> {
            String uuid = taskDir.getName();
            TsFileWriterManager writerManager = new TsFileWriterManager((File)taskDir);
            this.uuid2WriterManager.put(uuid, writerManager);
            writerManager.close();
            Map<String, CleanupTask> map = this.uuid2CleanupTask;
            synchronized (map) {
                CleanupTask cleanupTask = new CleanupTask(uuid, CONFIG.getLoadCleanupTaskExecutionDelayTimeSeconds() * 1000L);
                this.uuid2CleanupTask.put(uuid, cleanupTask);
                this.cleanupTaskQueue.add(cleanupTask);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToDataRegion(DataRegion dataRegion, LoadTsFilePieceNode pieceNode, String uuid) throws IOException {
        if (!this.uuid2WriterManager.containsKey(uuid)) {
            Map<String, CleanupTask> map = this.uuid2CleanupTask;
            synchronized (map) {
                CleanupTask cleanupTask = new CleanupTask(uuid, CONFIG.getLoadCleanupTaskExecutionDelayTimeSeconds() * 1000L);
                this.uuid2CleanupTask.put(uuid, cleanupTask);
                this.cleanupTaskQueue.add(cleanupTask);
            }
        }
        Optional<CleanupTask> cleanupTask = Optional.of(this.uuid2CleanupTask.get(uuid));
        cleanupTask.ifPresent(CleanupTask::markLoadTaskRunning);
        try {
            AtomicReference exception = new AtomicReference();
            TsFileWriterManager writerManager = this.uuid2WriterManager.computeIfAbsent(uuid, o -> {
                try {
                    return new TsFileWriterManager(new File(this.getNextFolder(), uuid));
                }
                catch (DiskSpaceInsufficientException e) {
                    exception.set(e);
                    return null;
                }
            });
            if (exception.get() != null || writerManager == null) {
                throw new IOException("Failed to create TsFileWriterManager for uuid " + uuid + " because of insufficient disk space.", (Throwable)exception.get());
            }
            for (TsFileData tsFileData : pieceNode.getAllTsFileData()) {
                if (!tsFileData.isModification()) {
                    ChunkData chunkData = (ChunkData)tsFileData;
                    writerManager.write(new DataPartitionInfo(dataRegion, chunkData.getTimePartitionSlot()), chunkData);
                    continue;
                }
                writerManager.writeDeletion(dataRegion, (DeletionData)tsFileData);
            }
        }
        finally {
            cleanupTask.ifPresent(CleanupTask::markLoadTaskNotRunning);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getNextFolder() throws DiskSpaceInsufficientException {
        AtomicReference<FolderManager> atomicReference;
        if (CONFIG.getLoadTsFileDirs() != LOAD_BASE_DIRS.get()) {
            atomicReference = FOLDER_MANAGER;
            synchronized (atomicReference) {
                if (CONFIG.getLoadTsFileDirs() != LOAD_BASE_DIRS.get()) {
                    LOAD_BASE_DIRS.set(CONFIG.getLoadTsFileDirs());
                    FOLDER_MANAGER.set(new FolderManager(Arrays.asList(LOAD_BASE_DIRS.get()), DirectoryStrategyType.SEQUENCE_STRATEGY));
                    return FOLDER_MANAGER.get().getNextFolder();
                }
            }
        }
        if (FOLDER_MANAGER.get() == null) {
            atomicReference = FOLDER_MANAGER;
            synchronized (atomicReference) {
                if (FOLDER_MANAGER.get() == null) {
                    FOLDER_MANAGER.set(new FolderManager(Arrays.asList(LOAD_BASE_DIRS.get()), DirectoryStrategyType.SEQUENCE_STRATEGY));
                    return FOLDER_MANAGER.get().getNextFolder();
                }
            }
        }
        return FOLDER_MANAGER.get().getNextFolder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadAll(String uuid, boolean isGeneratedByPipe, Map<TTimePartitionSlot, ProgressIndex> timePartitionProgressIndexMap) throws IOException, LoadFileException {
        if (!this.uuid2WriterManager.containsKey(uuid)) {
            return false;
        }
        Optional<CleanupTask> cleanupTask = Optional.of(this.uuid2CleanupTask.get(uuid));
        cleanupTask.ifPresent(CleanupTask::markLoadTaskRunning);
        try {
            this.uuid2WriterManager.get(uuid).loadAll(isGeneratedByPipe, timePartitionProgressIndexMap);
        }
        finally {
            cleanupTask.ifPresent(CleanupTask::markLoadTaskNotRunning);
        }
        this.clean(uuid);
        return true;
    }

    public boolean deleteAll(String uuid) {
        if (!this.uuid2WriterManager.containsKey(uuid)) {
            return false;
        }
        this.clean(uuid);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clean(String uuid) {
        Map<String, CleanupTask> map = this.uuid2CleanupTask;
        synchronized (map) {
            CleanupTask cleanupTask = this.uuid2CleanupTask.get(uuid);
            if (cleanupTask != null) {
                cleanupTask.cancel();
            }
        }
        this.forceCloseWriterManager(uuid);
    }

    private void forceCloseWriterManager(String uuid) {
        TsFileWriterManager writerManager = this.uuid2WriterManager.remove(uuid);
        if (Objects.nonNull(writerManager)) {
            writerManager.close();
        }
    }

    public static void updateWritePointCountMetrics(DataRegion dataRegion, String databaseName, long writePointCount, boolean isGeneratedByPipeConsensusLeader) {
        MemTableFlushTask.recordFlushPointsMetricInternal(writePointCount, databaseName, dataRegion.getDataRegionId());
        MetricService.getInstance().count(writePointCount, Metric.QUANTITY.toString(), MetricLevel.CORE, new String[]{Tag.NAME.toString(), Metric.POINTS_IN.toString(), Tag.DATABASE.toString(), databaseName, Tag.REGION.toString(), dataRegion.getDataRegionId(), Tag.TYPE.toString(), Metric.LOAD_POINT_COUNT.toString()});
        int replicationNum = DataRegionConsensusImpl.getInstance().getReplicationNum(ConsensusGroupId.Factory.create((int)TConsensusGroupType.DataRegion.getValue(), (int)Integer.parseInt(dataRegion.getDataRegionId())));
        if (replicationNum != 0 && !isGeneratedByPipeConsensusLeader) {
            MetricService.getInstance().count(writePointCount / (long)replicationNum, Metric.LEADER_QUANTITY.toString(), MetricLevel.CORE, new String[]{Tag.NAME.toString(), Metric.POINTS_IN.toString(), Tag.DATABASE.toString(), databaseName, Tag.REGION.toString(), dataRegion.getDataRegionId(), Tag.TYPE.toString(), Metric.LOAD_POINT_COUNT.toString()});
        }
    }

    private class CleanupTask
    implements Runnable,
    Comparable<CleanupTask> {
        private final String uuid;
        private final long delayInMs;
        private long scheduledTime;
        private volatile boolean isLoadTaskRunning = false;
        private volatile boolean isCanceled = false;

        private CleanupTask(String uuid, long delayInMs) {
            this.uuid = uuid;
            this.delayInMs = delayInMs;
            this.resetScheduledTime();
        }

        public void markLoadTaskRunning() {
            this.isLoadTaskRunning = true;
            this.resetScheduledTime();
        }

        public void markLoadTaskNotRunning() {
            this.isLoadTaskRunning = false;
            this.resetScheduledTime();
        }

        public void resetScheduledTime() {
            this.scheduledTime = System.currentTimeMillis() + this.delayInMs;
        }

        public void cancel() {
            this.isCanceled = true;
        }

        @Override
        public void run() {
            if (this.isCanceled) {
                LOGGER.info("Load cleanup task {} is canceled.", (Object)this.uuid);
            } else {
                LOGGER.info("Load cleanup task {} starts.", (Object)this.uuid);
                try {
                    LoadTsFileManager.this.forceCloseWriterManager(this.uuid);
                }
                catch (Exception e) {
                    LOGGER.warn("Load cleanup task {} error.", (Object)this.uuid, (Object)e);
                }
            }
        }

        @Override
        public int compareTo(CleanupTask that) {
            return Long.compare(this.scheduledTime, that.scheduledTime);
        }
    }

    private static class TsFileWriterManager {
        private final File taskDir;
        private Map<DataPartitionInfo, TsFileIOWriter> dataPartition2Writer;
        private Map<DataPartitionInfo, TsFileResource> dataPartition2Resource;
        private Map<DataPartitionInfo, String> dataPartition2LastDevice;
        private Map<DataPartitionInfo, ModificationFile> dataPartition2ModificationFile;
        private boolean isClosed;

        private TsFileWriterManager(File taskDir) {
            this.taskDir = taskDir;
            this.dataPartition2Writer = new HashMap<DataPartitionInfo, TsFileIOWriter>();
            this.dataPartition2Resource = new HashMap<DataPartitionInfo, TsFileResource>();
            this.dataPartition2LastDevice = new HashMap<DataPartitionInfo, String>();
            this.dataPartition2ModificationFile = new HashMap<DataPartitionInfo, ModificationFile>();
            this.isClosed = false;
            this.clearDir(taskDir);
        }

        private void clearDir(File dir) {
            if (dir.exists()) {
                FileUtils.deleteFileOrDirectoryWithRetry((File)dir);
            }
            if (dir.mkdirs()) {
                LOGGER.info("Load TsFile dir {} is created.", (Object)dir.getPath());
            }
        }

        private void write(DataPartitionInfo partitionInfo, ChunkData chunkData) throws IOException {
            if (this.isClosed) {
                throw new IOException(String.format(LoadTsFileManager.MESSAGE_WRITER_MANAGER_HAS_BEEN_CLOSED, this.taskDir));
            }
            if (!this.dataPartition2Writer.containsKey(partitionInfo)) {
                File newTsFile = SystemFileFactory.INSTANCE.getFile(this.taskDir, partitionInfo.toString() + ".tsfile");
                if (!newTsFile.createNewFile()) {
                    LOGGER.error("Can not create TsFile {} for writing.", (Object)newTsFile.getPath());
                    return;
                }
                long chunkMetadataMaxSizeForEachWriter = CONFIG.getLoadChunkMetadataMemorySizeInBytes() / (long)(this.dataPartition2Writer.size() + 1);
                TsFileIOWriter writer = new TsFileIOWriter(newTsFile, chunkMetadataMaxSizeForEachWriter);
                TsFileResource resource = new TsFileResource(writer.getFile());
                writer.addFlushListener(sortedChunkMetadataList -> sortedChunkMetadataList.forEach(pair -> {
                    IDeviceID deviceId = (IDeviceID)((Pair)pair.left).left;
                    ((List)pair.getRight()).forEach(chunkMetadata -> {
                        resource.updateStartTime(deviceId, chunkMetadata.getStartTime());
                        resource.updateEndTime(deviceId, chunkMetadata.getEndTime());
                    });
                }));
                for (TsFileIOWriter existingWriter : this.dataPartition2Writer.values()) {
                    existingWriter.setMaxMetadataSize(chunkMetadataMaxSizeForEachWriter);
                }
                this.dataPartition2Writer.put(partitionInfo, writer);
                this.dataPartition2Resource.put(partitionInfo, resource);
            }
            TsFileIOWriter writer = this.dataPartition2Writer.get(partitionInfo);
            if (!chunkData.getDevice().equals(this.dataPartition2LastDevice.getOrDefault(partitionInfo, ""))) {
                if (this.dataPartition2LastDevice.containsKey(partitionInfo)) {
                    writer.endChunkGroup();
                    writer.checkMetadataSizeAndMayFlush();
                }
                writer.startChunkGroup((IDeviceID)new PlainDeviceID(chunkData.getDevice()));
                this.dataPartition2LastDevice.put(partitionInfo, chunkData.getDevice());
            }
            chunkData.writeToFileWriter(writer);
        }

        private void writeDeletion(DataRegion dataRegion, DeletionData deletionData) throws IOException {
            if (this.isClosed) {
                throw new IOException(String.format(LoadTsFileManager.MESSAGE_WRITER_MANAGER_HAS_BEEN_CLOSED, this.taskDir));
            }
            for (Map.Entry<DataPartitionInfo, TsFileIOWriter> entry : this.dataPartition2Writer.entrySet()) {
                DataPartitionInfo partitionInfo = entry.getKey();
                if (!partitionInfo.getDataRegion().equals(dataRegion)) continue;
                TsFileIOWriter writer = entry.getValue();
                if (!this.dataPartition2ModificationFile.containsKey(partitionInfo)) {
                    File newModificationFile = SystemFileFactory.INSTANCE.getFile(writer.getFile().getAbsolutePath() + ".mods");
                    if (!newModificationFile.createNewFile()) {
                        LOGGER.error("Can not create ModificationFile {} for writing.", (Object)newModificationFile.getPath());
                        return;
                    }
                    this.dataPartition2ModificationFile.put(partitionInfo, new ModificationFile(newModificationFile.getAbsolutePath()));
                }
                ModificationFile modificationFile = this.dataPartition2ModificationFile.get(partitionInfo);
                writer.flush();
                deletionData.writeToModificationFile(modificationFile, writer.getFile().length());
            }
        }

        private void loadAll(boolean isGeneratedByPipe, Map<TTimePartitionSlot, ProgressIndex> timePartitionProgressIndexMap) throws IOException, LoadFileException {
            if (this.isClosed) {
                throw new IOException(String.format(LoadTsFileManager.MESSAGE_WRITER_MANAGER_HAS_BEEN_CLOSED, this.taskDir));
            }
            for (Map.Entry<DataPartitionInfo, ModificationFile> entry : this.dataPartition2ModificationFile.entrySet()) {
                entry.getValue().close();
            }
            for (Map.Entry<DataPartitionInfo, ModificationFile> entry : this.dataPartition2Writer.entrySet()) {
                TsFileIOWriter writer = (TsFileIOWriter)entry.getValue();
                if (writer.isWritingChunkGroup()) {
                    writer.endChunkGroup();
                }
                writer.endFile();
                DataRegion dataRegion = entry.getKey().getDataRegion();
                TsFileResource tsFileResource = this.dataPartition2Resource.get(entry.getKey());
                tsFileResource.setGeneratedByPipe(isGeneratedByPipe);
                this.endTsFileResource(writer, tsFileResource, timePartitionProgressIndexMap.getOrDefault(entry.getKey().getTimePartitionSlot(), (ProgressIndex)MinimumProgressIndex.INSTANCE));
                dataRegion.loadNewTsFile(tsFileResource, true, isGeneratedByPipe, false);
                dataRegion.getNonSystemDatabaseName().ifPresent(databaseName -> LoadTsFileManager.updateWritePointCountMetrics(dataRegion, databaseName, this.getTsFileWritePointCount(writer), false));
            }
        }

        private void endTsFileResource(TsFileIOWriter writer, TsFileResource tsFileResource, ProgressIndex progressIndex) throws IOException {
            HashMap<IDeviceID, Map> deviceLastValues = null;
            if (IoTDBDescriptor.getInstance().getConfig().isCacheLastValuesForLoad()) {
                deviceLastValues = new HashMap<IDeviceID, Map>();
            }
            AtomicLong lastValuesMemCost = new AtomicLong(0L);
            for (ChunkGroupMetadata chunkGroupMetadata : writer.getChunkGroupMetadataList()) {
                IDeviceID device = chunkGroupMetadata.getDevice();
                for (ChunkMetadata chunkMetadata : chunkGroupMetadata.getChunkMetadataList()) {
                    tsFileResource.updateStartTime(device, chunkMetadata.getStartTime());
                    tsFileResource.updateEndTime(device, chunkMetadata.getEndTime());
                    if (deviceLastValues == null) continue;
                    Map deviceMap = deviceLastValues.computeIfAbsent(device, d -> {
                        HashMap map = new HashMap();
                        lastValuesMemCost.addAndGet(RamUsageEstimator.shallowSizeOf(map));
                        lastValuesMemCost.addAndGet(device.ramBytesUsed());
                        return map;
                    });
                    int prevSize = deviceMap.size();
                    deviceMap.compute(chunkMetadata.getMeasurementUid(), (m, oldPair) -> {
                        TimeValuePair timeValuePair;
                        if (oldPair != null && oldPair.getTimestamp() > chunkMetadata.getEndTime()) {
                            return oldPair;
                        }
                        TsPrimitiveType lastValue = chunkMetadata.getStatistics() != null && chunkMetadata.getDataType() != TSDataType.BLOB ? TsPrimitiveType.getByType((TSDataType)(chunkMetadata.getDataType() == TSDataType.VECTOR ? TSDataType.INT64 : chunkMetadata.getDataType()), (Object)chunkMetadata.getStatistics().getLastValue()) : null;
                        TimeValuePair timeValuePair2 = timeValuePair = lastValue != null ? new TimeValuePair(chunkMetadata.getEndTime(), lastValue) : null;
                        if (oldPair != null) {
                            lastValuesMemCost.addAndGet(-oldPair.getSize());
                        }
                        if (timeValuePair != null) {
                            lastValuesMemCost.addAndGet(timeValuePair.getSize());
                        }
                        return timeValuePair;
                    });
                    int afterSize = deviceMap.size();
                    lastValuesMemCost.addAndGet((long)(afterSize - prevSize) * RamUsageEstimator.HASHTABLE_RAM_BYTES_PER_ENTRY);
                    if (lastValuesMemCost.get() <= IoTDBDescriptor.getInstance().getConfig().getCacheLastValuesMemoryBudgetInByte()) continue;
                    deviceLastValues = null;
                }
            }
            if (deviceLastValues != null) {
                HashMap<IDeviceID, List<Pair<String, TimeValuePair>>> finalDeviceLastValues = new HashMap<IDeviceID, List<Pair<String, TimeValuePair>>>(deviceLastValues.size());
                for (Map.Entry entry : deviceLastValues.entrySet()) {
                    IDeviceID device = (IDeviceID)entry.getKey();
                    Map lastValues = (Map)entry.getValue();
                    List pairList = lastValues.entrySet().stream().map(e -> new Pair((Object)((String)e.getKey()), (Object)((TimeValuePair)e.getValue()))).collect(Collectors.toList());
                    finalDeviceLastValues.put(device, pairList);
                }
                tsFileResource.setLastValues(finalDeviceLastValues);
            }
            tsFileResource.setStatus(TsFileResourceStatus.NORMAL);
            tsFileResource.setProgressIndex(progressIndex);
            tsFileResource.serialize();
        }

        private long getTsFileWritePointCount(TsFileIOWriter writer) {
            return writer.getChunkGroupMetadataList().stream().flatMap(chunkGroupMetadata -> chunkGroupMetadata.getChunkMetadataList().stream()).mapToLong(chunkMetadata -> chunkMetadata.getStatistics().getCount()).sum();
        }

        private void close() {
            if (this.isClosed) {
                return;
            }
            if (this.dataPartition2Writer != null) {
                for (Map.Entry<DataPartitionInfo, Object> entry : this.dataPartition2Writer.entrySet()) {
                    try {
                        Path writerPath;
                        TsFileIOWriter writer = (TsFileIOWriter)entry.getValue();
                        if (writer.canWrite()) {
                            writer.close();
                        }
                        if (!Files.exists(writerPath = writer.getFile().toPath(), new LinkOption[0])) continue;
                        RetryUtils.retryOnException(() -> {
                            Files.delete(writerPath);
                            return null;
                        });
                    }
                    catch (IOException e) {
                        LOGGER.warn("Close TsFileIOWriter {} error.", (Object)((TsFileIOWriter)entry.getValue()).getFile().getPath(), (Object)e);
                    }
                }
            }
            if (this.dataPartition2ModificationFile != null) {
                for (Map.Entry<DataPartitionInfo, Object> entry : this.dataPartition2ModificationFile.entrySet()) {
                    try {
                        ModificationFile modificationFile = (ModificationFile)entry.getValue();
                        modificationFile.close();
                        Path modificationFilePath = new File(modificationFile.getFilePath()).toPath();
                        if (!Files.exists(modificationFilePath, new LinkOption[0])) continue;
                        RetryUtils.retryOnException(() -> {
                            Files.delete(modificationFilePath);
                            return null;
                        });
                    }
                    catch (IOException e) {
                        LOGGER.warn("Close ModificationFile {} error.", (Object)((ModificationFile)entry.getValue()).getFilePath(), (Object)e);
                    }
                }
            }
            try {
                RetryUtils.retryOnException(() -> {
                    Files.delete(this.taskDir.toPath());
                    return null;
                });
            }
            catch (DirectoryNotEmptyException e) {
                LOGGER.info("Task dir {} is not empty, skip deleting.", (Object)this.taskDir.getPath());
            }
            catch (IOException e) {
                LOGGER.warn(LoadTsFileManager.MESSAGE_DELETE_FAIL, (Object)this.taskDir.getPath(), (Object)e);
            }
            this.dataPartition2Writer = null;
            this.dataPartition2LastDevice = null;
            this.dataPartition2ModificationFile = null;
            this.isClosed = true;
        }
    }

    private static class DataPartitionInfo {
        private final DataRegion dataRegion;
        private final TTimePartitionSlot timePartitionSlot;

        private DataPartitionInfo(DataRegion dataRegion, TTimePartitionSlot timePartitionSlot) {
            this.dataRegion = dataRegion;
            this.timePartitionSlot = timePartitionSlot;
        }

        public DataRegion getDataRegion() {
            return this.dataRegion;
        }

        public TTimePartitionSlot getTimePartitionSlot() {
            return this.timePartitionSlot;
        }

        public String toString() {
            return String.join((CharSequence)"-", this.dataRegion.getDatabaseName(), this.dataRegion.getDataRegionId(), Long.toString(this.timePartitionSlot.getStartTime()));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DataPartitionInfo that = (DataPartitionInfo)o;
            return Objects.equals(this.dataRegion, that.dataRegion) && this.timePartitionSlot.getStartTime() == that.timePartitionSlot.getStartTime();
        }

        public int hashCode() {
            return Objects.hash(this.dataRegion, this.timePartitionSlot.getStartTime());
        }
    }
}

