/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.specialized;

import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.storage.blob.models.BlobProperties;
import com.azure.storage.blob.models.BlobRange;
import com.azure.storage.blob.models.BlobRequestConditions;
import com.azure.storage.blob.models.BlobStorageException;
import com.azure.storage.blob.specialized.BlobClientBase;
import com.azure.storage.common.StorageInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public final class BlobInputStream
extends StorageInputStream {
    private final BlobClientBase blobClient;
    private final BlobRequestConditions accessCondition;
    private final BlobProperties properties;
    private final Context context;

    BlobInputStream(BlobClientBase blobClient, long blobRangeOffset, Long blobRangeLength, int chunkSize, ByteBuffer initialBuffer, BlobRequestConditions accessCondition, BlobProperties blobProperties, Context context) throws BlobStorageException {
        super(blobRangeOffset, blobRangeLength, chunkSize, BlobInputStream.adjustBlobLength(blobProperties.getBlobSize(), context), initialBuffer);
        this.blobClient = blobClient;
        this.accessCondition = accessCondition;
        this.properties = blobProperties;
        this.context = context;
    }

    protected synchronized ByteBuffer dispatchRead(int readLength, long offset) throws IOException {
        try {
            ByteBuffer currentBuffer = ((BinaryData)this.blobClient.downloadContentWithResponse(null, this.accessCondition, new BlobRange(offset, Long.valueOf(readLength)), false, null, this.context).getValue()).toByteBuffer();
            this.bufferSize = readLength;
            this.bufferStartOffset = offset;
            return currentBuffer;
        }
        catch (BlobStorageException e) {
            this.streamFaulted = true;
            this.lastError = new IOException((Throwable)((Object)e));
            throw this.lastError;
        }
    }

    public BlobProperties getProperties() {
        return this.properties;
    }

    private static long adjustBlobLength(long initialLength, Context context) {
        if (context != null && context.getData((Object)"adjustedBlobLength").isPresent()) {
            return (Long)context.getData((Object)"adjustedBlobLength").get();
        }
        return initialLength;
    }
}

