/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.credentials.connection;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import org.apache.polaris.core.credentials.connection.CatalogAccessProperty;
import org.apache.polaris.core.credentials.connection.ImmutableConnectionCredentials;
import org.apache.polaris.immutables.PolarisImmutable;

@PolarisImmutable
public interface ConnectionCredentials {
    public Map<String, String> credentials();

    public Optional<Instant> expiresAt();

    default public String get(CatalogAccessProperty key) {
        return this.credentials().get(key.getPropertyName());
    }

    public static Builder builder() {
        return ImmutableConnectionCredentials.builder();
    }

    public static interface Builder {
        @CanIgnoreReturnValue
        public Builder putCredential(String var1, String var2);

        @CanIgnoreReturnValue
        public Builder expiresAt(Instant var1);

        default public Builder put(CatalogAccessProperty key, String value) {
            if (key.isExpirationTimestamp()) {
                this.expiresAt(Instant.ofEpochMilli(Long.parseLong(value)));
            }
            if (key.isCredential()) {
                return this.putCredential(key.getPropertyName(), value);
            }
            return this;
        }

        public ConnectionCredentials build();
    }
}

