/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basecluster.transport;

import com.google.protobuf.ByteString;
import io.netty.handler.ssl.SslContext;
import io.reactivex.rxjava3.core.Observable;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.apache.bifromq.basecluster.transport.ITransport;
import org.apache.bifromq.basecluster.transport.PacketEnvelope;
import org.apache.bifromq.basecluster.transport.TCPTransport;
import org.apache.bifromq.basecluster.transport.UDPTransport;

public final class Transport
implements ITransport {
    private final ITransport tcpTransport;
    private final ITransport udpTransport;
    private final TransportOptions options;
    private final Observable<PacketEnvelope> sink;

    Transport(InetSocketAddress bindAddr, SslContext serverSslContext, SslContext clientSslContext, String env, TransportOptions options) {
        env = env == null ? "" : env;
        TransportOptions transportOptions = this.options = options == null ? new TransportOptions() : options.toBuilder().build();
        if (bindAddr == null) {
            bindAddr = new InetSocketAddress(0);
        }
        this.tcpTransport = TCPTransport.builder().bindAddr(bindAddr).env(env).serverSslContext(serverSslContext).clientSslContext(clientSslContext).opts(this.options.tcpTransportOptions).build();
        this.udpTransport = UDPTransport.builder().env(env).bindAddr(this.tcpTransport.bindAddress()).build();
        this.sink = Observable.merge(this.tcpTransport.receive(), this.udpTransport.receive());
    }

    @Override
    public InetSocketAddress bindAddress() {
        return this.tcpTransport.bindAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> send(List<ByteString> data, InetSocketAddress recipient) {
        int size = data.stream().map(ByteString::size).reduce(0, Integer::sum);
        try {
            if (Boolean.TRUE.equals(RELIABLE.get()) || (long)size > this.options.mtu) {
                CompletableFuture<Void> completableFuture = this.tcpTransport.send(data, recipient);
                return completableFuture;
            }
            CompletableFuture<Void> completableFuture = this.udpTransport.send(data, recipient);
            return completableFuture;
        }
        finally {
            RELIABLE.set(false);
        }
    }

    @Override
    public Observable<PacketEnvelope> receive() {
        return this.sink;
    }

    @Override
    public CompletableFuture<Void> shutdown() {
        return CompletableFuture.allOf(new CompletableFuture[]{this.tcpTransport.shutdown().exceptionally(e -> null), this.udpTransport.shutdown().exceptionally(e -> null)});
    }

    @Generated
    public static TransportBuilder builder() {
        return new TransportBuilder();
    }

    public static class TransportOptions {
        private long mtu;
        private TCPTransport.TCPTransportOptions tcpTransportOptions;

        @Generated
        private static long $default$mtu() {
            return 1400L;
        }

        @Generated
        private static TCPTransport.TCPTransportOptions $default$tcpTransportOptions() {
            return new TCPTransport.TCPTransportOptions();
        }

        @Generated
        public static TransportOptionsBuilder builder() {
            return new TransportOptionsBuilder();
        }

        @Generated
        public TransportOptionsBuilder toBuilder() {
            return new TransportOptionsBuilder().mtu(this.mtu).tcpTransportOptions(this.tcpTransportOptions);
        }

        @Generated
        public long mtu() {
            return this.mtu;
        }

        @Generated
        public TCPTransport.TCPTransportOptions tcpTransportOptions() {
            return this.tcpTransportOptions;
        }

        @Generated
        public TransportOptions mtu(long mtu) {
            this.mtu = mtu;
            return this;
        }

        @Generated
        public TransportOptions tcpTransportOptions(TCPTransport.TCPTransportOptions tcpTransportOptions) {
            this.tcpTransportOptions = tcpTransportOptions;
            return this;
        }

        @Generated
        public TransportOptions() {
            this.mtu = TransportOptions.$default$mtu();
            this.tcpTransportOptions = TransportOptions.$default$tcpTransportOptions();
        }

        @Generated
        private TransportOptions(long mtu, TCPTransport.TCPTransportOptions tcpTransportOptions) {
            this.mtu = mtu;
            this.tcpTransportOptions = tcpTransportOptions;
        }

        @Generated
        public static class TransportOptionsBuilder {
            @Generated
            private boolean mtu$set;
            @Generated
            private long mtu$value;
            @Generated
            private boolean tcpTransportOptions$set;
            @Generated
            private TCPTransport.TCPTransportOptions tcpTransportOptions$value;

            @Generated
            TransportOptionsBuilder() {
            }

            @Generated
            public TransportOptionsBuilder mtu(long mtu) {
                this.mtu$value = mtu;
                this.mtu$set = true;
                return this;
            }

            @Generated
            public TransportOptionsBuilder tcpTransportOptions(TCPTransport.TCPTransportOptions tcpTransportOptions) {
                this.tcpTransportOptions$value = tcpTransportOptions;
                this.tcpTransportOptions$set = true;
                return this;
            }

            @Generated
            public TransportOptions build() {
                long mtu$value = this.mtu$value;
                if (!this.mtu$set) {
                    mtu$value = TransportOptions.$default$mtu();
                }
                TCPTransport.TCPTransportOptions tcpTransportOptions$value = this.tcpTransportOptions$value;
                if (!this.tcpTransportOptions$set) {
                    tcpTransportOptions$value = TransportOptions.$default$tcpTransportOptions();
                }
                return new TransportOptions(mtu$value, tcpTransportOptions$value);
            }

            @Generated
            public String toString() {
                return "Transport.TransportOptions.TransportOptionsBuilder(mtu$value=" + this.mtu$value + ", tcpTransportOptions$value=" + String.valueOf(this.tcpTransportOptions$value) + ")";
            }
        }
    }

    @Generated
    public static class TransportBuilder {
        @Generated
        private InetSocketAddress bindAddr;
        @Generated
        private SslContext serverSslContext;
        @Generated
        private SslContext clientSslContext;
        @Generated
        private String env;
        @Generated
        private TransportOptions options;

        @Generated
        TransportBuilder() {
        }

        @Generated
        public TransportBuilder bindAddr(InetSocketAddress bindAddr) {
            this.bindAddr = bindAddr;
            return this;
        }

        @Generated
        public TransportBuilder serverSslContext(SslContext serverSslContext) {
            this.serverSslContext = serverSslContext;
            return this;
        }

        @Generated
        public TransportBuilder clientSslContext(SslContext clientSslContext) {
            this.clientSslContext = clientSslContext;
            return this;
        }

        @Generated
        public TransportBuilder env(String env) {
            this.env = env;
            return this;
        }

        @Generated
        public TransportBuilder options(TransportOptions options) {
            this.options = options;
            return this;
        }

        @Generated
        public Transport build() {
            return new Transport(this.bindAddr, this.serverSslContext, this.clientSslContext, this.env, this.options);
        }

        @Generated
        public String toString() {
            return "Transport.TransportBuilder(bindAddr=" + String.valueOf(this.bindAddr) + ", serverSslContext=" + String.valueOf(this.serverSslContext) + ", clientSslContext=" + String.valueOf(this.clientSslContext) + ", env=" + this.env + ", options=" + String.valueOf(this.options) + ")";
        }
    }
}

