/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.table.criteria;

import org.apache.ignite3.internal.lang.IgniteExceptionMapperUtil;
import org.apache.ignite3.lang.ErrorGroups;
import org.apache.ignite3.lang.TraceableException;
import org.apache.ignite3.table.criteria.CriteriaException;

public class CriteriaExceptionMapperUtil {
    public static Throwable mapToPublicCriteriaException(Throwable origin) {
        Throwable e = IgniteExceptionMapperUtil.mapToPublicException(origin);
        if (e instanceof Error) {
            return e;
        }
        if (e instanceof CriteriaException) {
            return e;
        }
        if (e instanceof TraceableException) {
            TraceableException traceable = (TraceableException)((Object)e);
            return new CriteriaException(traceable.traceId(), traceable.code(), e.getMessage(), e);
        }
        return new CriteriaException(ErrorGroups.Common.INTERNAL_ERR, e);
    }
}

