/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.util;

import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.beam.runners.core.InMemoryMultimapSideInputView;
import org.apache.beam.runners.core.SideInputReader;
import org.apache.beam.runners.spark.util.SideInputBroadcast;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.transforms.ViewFn;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class SparkSideInputReader
implements SideInputReader {
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized SideInputBroadcast<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>>> sideInputs;

    public SparkSideInputReader(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized SideInputBroadcast<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>>> sideInputs) {
        this.sideInputs = sideInputs;
    }

    public <T> @Nullable T get(@UnknownKeyFor @NonNull @Initialized PCollectionView<T> view, @UnknownKeyFor @NonNull @Initialized BoundedWindow window) {
        Preconditions.checkNotNull(view, (Object)"The PCollectionView passed to sideInput cannot be null ");
        KV<WindowingStrategy<?, ?>, SideInputBroadcast<?>> windowedBroadcastHelper = this.sideInputs.get(view.getTagInternal());
        Preconditions.checkNotNull(windowedBroadcastHelper, (Object)("SideInput for view " + view + " is not available."));
        BoundedWindow sideInputWindow = view.getWindowMappingFn().getSideInputWindow(window);
        Iterable availableSideInputs = (Iterable)((SideInputBroadcast)windowedBroadcastHelper.getValue()).getValue();
        Iterable sideInputForWindow = StreamSupport.stream(availableSideInputs.spliterator(), false).filter(sideInputCandidate -> {
            if (sideInputCandidate == null) {
                return false;
            }
            return Iterables.contains((Iterable)sideInputCandidate.getWindows(), (Object)sideInputWindow);
        }).collect(Collectors.toList()).stream().map(WindowedValue::getValue).collect(Collectors.toList());
        switch (view.getViewFn().getMaterialization().getUrn()) {
            case "beam:side_input:iterable:v1": {
                ViewFn viewFn = view.getViewFn();
                return (T)viewFn.apply(() -> sideInputForWindow);
            }
            case "beam:side_input:multimap:v1": {
                ViewFn viewFn = view.getViewFn();
                Coder keyCoder = ((KvCoder)view.getCoderInternal()).getKeyCoder();
                return (T)viewFn.apply((Object)InMemoryMultimapSideInputView.fromIterable((Coder)keyCoder, (Iterable)sideInputForWindow));
            }
        }
        throw new IllegalStateException(String.format("Unknown side input materialization format requested '%s'", view.getViewFn().getMaterialization().getUrn()));
    }

    public <T> @UnknownKeyFor @NonNull @Initialized boolean contains(@UnknownKeyFor @NonNull @Initialized PCollectionView<T> view) {
        return this.sideInputs.containsKey(view.getTagInternal());
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isEmpty() {
        return this.sideInputs != null && this.sideInputs.isEmpty();
    }
}

