/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.mongo;

import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.hop.mongo.KerberosUtil;
import org.apache.hop.mongo.MongoDbException;
import org.apache.hop.mongo.MongoProp;
import org.apache.hop.mongo.MongoProperties;

public class KerberosHelper {
    private static KerberosUtil.JaasAuthenticationMode lookupLoginAuthMode(MongoProperties props) throws MongoDbException {
        return KerberosUtil.JaasAuthenticationMode.byName(props.get(MongoProp.HOP_JAAS_AUTH_MODE));
    }

    private static String lookupKeytabFile(MongoProperties props) {
        return props.get(MongoProp.HOP_JAAS_KEYTAB_FILE);
    }

    public static LoginContext login(String principal, MongoProperties props) throws MongoDbException {
        try {
            KerberosUtil.JaasAuthenticationMode authMode = KerberosHelper.lookupLoginAuthMode(props);
            String keytabFile = KerberosHelper.lookupKeytabFile(props);
            return KerberosUtil.loginAs(authMode, principal, keytabFile);
        }
        catch (LoginException ex) {
            throw new MongoDbException("Unable to authenticate as '" + principal + "'", ex);
        }
    }
}

