/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.vfs.azure;

import com.microsoft.azure.storage.CloudStorageAccount;
import com.microsoft.azure.storage.blob.CloudBlobClient;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.UserAuthenticationData;
import org.apache.commons.vfs2.provider.AbstractOriginatingFileProvider;
import org.apache.commons.vfs2.provider.FileNameParser;
import org.apache.commons.vfs2.util.UserAuthenticatorUtils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.variables.Variables;
import org.apache.hop.vfs.azure.AzureFileName;
import org.apache.hop.vfs.azure.AzureFileNameParser;
import org.apache.hop.vfs.azure.AzureFileSystem;
import org.apache.hop.vfs.azure.config.AzureConfig;
import org.apache.hop.vfs.azure.config.AzureConfigSingleton;

public class AzureFileProvider
extends AbstractOriginatingFileProvider {
    public static final Collection<Capability> capabilities = Collections.unmodifiableCollection(Arrays.asList(Capability.CREATE, Capability.DELETE, Capability.ATTRIBUTES, Capability.GET_TYPE, Capability.GET_LAST_MODIFIED, Capability.LIST_CHILDREN, Capability.READ_CONTENT, Capability.URI, Capability.WRITE_CONTENT));
    public static final UserAuthenticationData.Type[] AUTHENTICATOR_TYPES = new UserAuthenticationData.Type[]{UserAuthenticationData.USERNAME, UserAuthenticationData.PASSWORD};
    private static FileSystemOptions defaultOptions = new FileSystemOptions();
    private Log logger = LogFactory.getLog(AzureFileProvider.class);

    public static FileSystemOptions getDefaultFileSystemOptions() {
        return defaultOptions;
    }

    public AzureFileProvider() {
        this.setFileNameParser((FileNameParser)AzureFileNameParser.getInstance());
    }

    protected FileSystem doCreateFileSystem(FileName fileName, FileSystemOptions fileSystemOptions) throws FileSystemException {
        CloudBlobClient service;
        FileSystemOptions fsOptions = fileSystemOptions != null ? fileSystemOptions : AzureFileProvider.getDefaultFileSystemOptions();
        UserAuthenticationData authData = null;
        try {
            authData = UserAuthenticatorUtils.authenticate((FileSystemOptions)fsOptions, (UserAuthenticationData.Type[])AUTHENTICATOR_TYPES);
            this.logger.info((Object)"Initialize Azure client");
            AzureConfig config = AzureConfigSingleton.getConfig();
            if (StringUtils.isEmpty((String)config.getAccount())) {
                throw new FileSystemException("Please configure the Azure account to use in the configuration (Options dialog or with hop-conf)");
            }
            if (StringUtils.isEmpty((String)config.getKey())) {
                throw new FileSystemException("Please configure the Azure key to use in the configuration (Options dialog or with hop-conf)");
            }
            IVariables variables = Variables.getADefaultVariableSpace();
            String account = variables.resolve(config.getAccount());
            String key = variables.resolve(config.getKey());
            String storageConnectionString = String.format("DefaultEndpointsProtocol=https;AccountName=%s;AccountKey=%s;EndpointSuffix=core.windows.net", account, key);
            CloudStorageAccount storageAccount = CloudStorageAccount.parse((String)storageConnectionString);
            service = storageAccount.createCloudBlobClient();
        }
        catch (InvalidKeyException e) {
            throw new FileSystemException(e.getMessage(), (Throwable)e);
        }
        catch (URISyntaxException e) {
            throw new FileSystemException(e.getMessage(), (Throwable)e);
        }
        finally {
            UserAuthenticatorUtils.cleanup((UserAuthenticationData)authData);
        }
        return new AzureFileSystem((AzureFileName)fileName, service, fsOptions);
    }

    public Collection<Capability> getCapabilities() {
        return capabilities;
    }
}

