/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.beam.repackaged.direct_java.runners.core.KeyedWorkItem;
import org.apache.beam.repackaged.direct_java.runners.core.KeyedWorkItems;
import org.apache.beam.repackaged.direct_java.runners.core.TimerInternals;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.IterableCoder;
import org.apache.beam.sdk.coders.StructuredCoder;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class KeyedWorkItemCoder<@UnknownKeyFor K, @UnknownKeyFor ElemT>
extends StructuredCoder<KeyedWorkItem<K, ElemT>> {
    private final @UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder;
    private final @UnknownKeyFor @NonNull @Initialized Coder<ElemT> elemCoder;
    private final @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> windowCoder;
    private final @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData>> timersCoder;
    private final @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized WindowedValue<ElemT>>> elemsCoder;

    public static <K, ElemT> @UnknownKeyFor @NonNull @Initialized KeyedWorkItemCoder<K, ElemT> of(@UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder, @UnknownKeyFor @NonNull @Initialized Coder<ElemT> elemCoder, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> windowCoder) {
        return new KeyedWorkItemCoder<K, ElemT>(keyCoder, elemCoder, windowCoder);
    }

    private KeyedWorkItemCoder(@UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder, @UnknownKeyFor @NonNull @Initialized Coder<ElemT> elemCoder, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> windowCoder) {
        this.keyCoder = keyCoder;
        this.elemCoder = elemCoder;
        this.windowCoder = windowCoder;
        this.timersCoder = IterableCoder.of((Coder)TimerInternals.TimerDataCoderV2.of(windowCoder));
        this.elemsCoder = IterableCoder.of((Coder)WindowedValue.FullWindowedValueCoder.of(elemCoder, windowCoder));
    }

    public @UnknownKeyFor @NonNull @Initialized Coder<K> getKeyCoder() {
        return this.keyCoder;
    }

    public @UnknownKeyFor @NonNull @Initialized Coder<ElemT> getElementCoder() {
        return this.elemCoder;
    }

    public void encode(@UnknownKeyFor @NonNull @Initialized KeyedWorkItem<K, ElemT> value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
        this.keyCoder.encode(value.key(), outStream);
        this.timersCoder.encode(value.timersIterable(), outStream);
        this.elemsCoder.encode(value.elementsIterable(), outStream);
    }

    public @UnknownKeyFor @NonNull @Initialized KeyedWorkItem<K, ElemT> decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
        Object key = this.keyCoder.decode(inStream);
        Iterable timers = (Iterable)this.timersCoder.decode(inStream);
        Iterable elems = (Iterable)this.elemsCoder.decode(inStream);
        return KeyedWorkItems.workItem(key, timers, elems);
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getCoderArguments() {
        return ImmutableList.of(this.keyCoder, this.elemCoder, this.windowCoder);
    }

    public void verifyDeterministic() throws // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Coder.NonDeterministicException {
        this.keyCoder.verifyDeterministic();
        this.timersCoder.verifyDeterministic();
        this.elemsCoder.verifyDeterministic();
    }

    public @UnknownKeyFor @NonNull @Initialized boolean consistentWithEquals() {
        return false;
    }
}

