/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kinesis;

import com.amazonaws.services.kinesis.clientlibrary.lib.worker.InitialPositionInStream;
import com.amazonaws.services.kinesis.model.ExpiredIteratorException;
import com.amazonaws.services.kinesis.model.Shard;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.beam.sdk.io.kinesis.GetKinesisRecordsResult;
import org.apache.beam.sdk.io.kinesis.KinesisRecord;
import org.apache.beam.sdk.io.kinesis.KinesisShardClosedException;
import org.apache.beam.sdk.io.kinesis.RecordFilter;
import org.apache.beam.sdk.io.kinesis.ShardCheckpoint;
import org.apache.beam.sdk.io.kinesis.SimplifiedKinesisClient;
import org.apache.beam.sdk.io.kinesis.StartingPoint;
import org.apache.beam.sdk.io.kinesis.TransientKinesisException;
import org.apache.beam.sdk.io.kinesis.WatermarkPolicy;
import org.apache.beam.sdk.io.kinesis.WatermarkPolicyFactory;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ShardRecordsIterator {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(ShardRecordsIterator.class);
    private final @UnknownKeyFor @NonNull @Initialized SimplifiedKinesisClient kinesis;
    private final @UnknownKeyFor @NonNull @Initialized RecordFilter filter;
    private final @UnknownKeyFor @NonNull @Initialized String streamName;
    private final @UnknownKeyFor @NonNull @Initialized String shardId;
    private final @UnknownKeyFor @NonNull @Initialized AtomicReference<@UnknownKeyFor @NonNull @Initialized ShardCheckpoint> checkpoint;
    private final @UnknownKeyFor @NonNull @Initialized WatermarkPolicy watermarkPolicy;
    private final @UnknownKeyFor @NonNull @Initialized WatermarkPolicyFactory watermarkPolicyFactory;
    private final @UnknownKeyFor @NonNull @Initialized WatermarkPolicy latestRecordTimestampPolicy = WatermarkPolicyFactory.withArrivalTimePolicy().createWatermarkPolicy();
    private @UnknownKeyFor @NonNull @Initialized String shardIterator;

    ShardRecordsIterator(@UnknownKeyFor @NonNull @Initialized ShardCheckpoint initialCheckpoint, @UnknownKeyFor @NonNull @Initialized SimplifiedKinesisClient simplifiedKinesisClient, @UnknownKeyFor @NonNull @Initialized WatermarkPolicyFactory watermarkPolicyFactory) throws @UnknownKeyFor @NonNull @Initialized TransientKinesisException {
        this(initialCheckpoint, simplifiedKinesisClient, watermarkPolicyFactory, new RecordFilter());
    }

    ShardRecordsIterator(@UnknownKeyFor @NonNull @Initialized ShardCheckpoint initialCheckpoint, @UnknownKeyFor @NonNull @Initialized SimplifiedKinesisClient simplifiedKinesisClient, @UnknownKeyFor @NonNull @Initialized WatermarkPolicyFactory watermarkPolicyFactory, @UnknownKeyFor @NonNull @Initialized RecordFilter filter) throws @UnknownKeyFor @NonNull @Initialized TransientKinesisException {
        this.checkpoint = new AtomicReference<ShardCheckpoint>((ShardCheckpoint)Preconditions.checkNotNull((Object)initialCheckpoint, (Object)"initialCheckpoint"));
        this.filter = (RecordFilter)Preconditions.checkNotNull((Object)filter, (Object)"filter");
        this.kinesis = (SimplifiedKinesisClient)Preconditions.checkNotNull((Object)simplifiedKinesisClient, (Object)"simplifiedKinesisClient");
        this.streamName = initialCheckpoint.getStreamName();
        this.shardId = initialCheckpoint.getShardId();
        this.shardIterator = initialCheckpoint.getShardIterator(this.kinesis);
        this.watermarkPolicy = watermarkPolicyFactory.createWatermarkPolicy();
        this.watermarkPolicyFactory = watermarkPolicyFactory;
    }

    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized KinesisRecord> readNextBatch() throws @UnknownKeyFor @NonNull @Initialized TransientKinesisException, @UnknownKeyFor @NonNull @Initialized KinesisShardClosedException {
        if (this.shardIterator == null) {
            throw new KinesisShardClosedException(String.format("Shard iterator reached end of the shard: streamName=%s, shardId=%s", this.streamName, this.shardId));
        }
        GetKinesisRecordsResult response = this.fetchRecords();
        LOG.debug("Fetched {} new records from shard: streamName={}, shardId={}", new Object[]{response.getRecords().size(), this.streamName, this.shardId});
        List<KinesisRecord> filteredRecords = this.filter.apply(response.getRecords(), this.checkpoint.get());
        return filteredRecords;
    }

    private @UnknownKeyFor @NonNull @Initialized GetKinesisRecordsResult fetchRecords() throws @UnknownKeyFor @NonNull @Initialized TransientKinesisException {
        try {
            GetKinesisRecordsResult response = this.kinesis.getRecords(this.shardIterator, this.streamName, this.shardId);
            this.shardIterator = response.getNextShardIterator();
            return response;
        }
        catch (ExpiredIteratorException e) {
            LOG.info("Refreshing expired iterator for shard: streamName={}, shardId={}", new Object[]{this.streamName, this.shardId, e});
            this.shardIterator = this.checkpoint.get().getShardIterator(this.kinesis);
            return this.fetchRecords();
        }
    }

    @UnknownKeyFor @NonNull @Initialized ShardCheckpoint getCheckpoint() {
        return this.checkpoint.get();
    }

    void ackRecord(@UnknownKeyFor @NonNull @Initialized KinesisRecord record) {
        this.checkpoint.set(this.checkpoint.get().moveAfter(record));
        this.watermarkPolicy.update(record);
        this.latestRecordTimestampPolicy.update(record);
    }

    @UnknownKeyFor @NonNull @Initialized Instant getShardWatermark() {
        return this.watermarkPolicy.getWatermark();
    }

    @UnknownKeyFor @NonNull @Initialized Instant getLatestRecordTimestamp() {
        return this.latestRecordTimestampPolicy.getWatermark();
    }

    @UnknownKeyFor @NonNull @Initialized String getShardId() {
        return this.shardId;
    }

    @UnknownKeyFor @NonNull @Initialized String getStreamName() {
        return this.streamName;
    }

    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ShardRecordsIterator> findSuccessiveShardRecordIterators() throws @UnknownKeyFor @NonNull @Initialized TransientKinesisException {
        List<Shard> shards = this.kinesis.listShardsFollowingClosedShard(this.streamName, this.shardId);
        ArrayList<ShardRecordsIterator> successiveShardRecordIterators = new ArrayList<ShardRecordsIterator>();
        for (Shard shard : shards) {
            if (!this.shardId.equals(shard.getParentShardId())) continue;
            ShardCheckpoint shardCheckpoint = new ShardCheckpoint(this.streamName, shard.getShardId(), new StartingPoint(InitialPositionInStream.TRIM_HORIZON));
            successiveShardRecordIterators.add(new ShardRecordsIterator(shardCheckpoint, this.kinesis, this.watermarkPolicyFactory));
        }
        return successiveShardRecordIterators;
    }
}

