/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.row;

import java.math.BigDecimal;
import java.util.Date;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaBase;
import org.apache.hop.core.row.value.ValueMetaBigNumber;
import org.apache.hop.core.row.value.ValueMetaBinary;
import org.apache.hop.core.row.value.ValueMetaBoolean;
import org.apache.hop.core.row.value.ValueMetaDate;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.row.value.ValueMetaNumber;
import org.apache.hop.core.row.value.ValueMetaSerializable;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.xml.XmlHandler;
import org.w3c.dom.Node;

public class ValueMetaAndData {
    public static final String XML_TAG = "value";
    private IValueMeta valueMeta;
    private Object valueData;

    public ValueMetaAndData() {
    }

    public ValueMetaAndData(IValueMeta valueMeta, Object valueData) {
        this.valueMeta = valueMeta;
        this.valueData = valueData;
    }

    public ValueMetaAndData(String valueName, Object valueData) {
        this.valueData = valueData;
        this.valueMeta = valueData instanceof String ? new ValueMetaString(valueName) : (valueData instanceof Double ? new ValueMetaNumber(valueName) : (valueData instanceof Long ? new ValueMetaInteger(valueName) : (valueData instanceof Date ? new ValueMetaDate(valueName) : (valueData instanceof BigDecimal ? new ValueMetaBigNumber(valueName) : (valueData instanceof Boolean ? new ValueMetaBoolean(valueName) : (valueData instanceof byte[] ? new ValueMetaBinary(valueName) : new ValueMetaSerializable(valueName)))))));
    }

    public ValueMetaAndData(ValueMetaAndData v) {
        try {
            this.valueMeta = v.valueMeta.clone();
            this.valueData = v.valueMeta.cloneValueData(v.getValueData());
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating copy of value and metadata", e);
        }
    }

    public Object clone() {
        ValueMetaAndData vmad = new ValueMetaAndData();
        try {
            vmad.valueData = this.valueMeta.cloneValueData(this.valueData);
        }
        catch (HopValueException e) {
            throw new RuntimeException("Error cloning value data", e);
        }
        vmad.valueMeta = this.valueMeta.clone();
        return vmad;
    }

    public String toString() {
        if (this.valueMeta == null) {
            return "";
        }
        try {
            return this.valueMeta.getString(this.valueData);
        }
        catch (HopValueException e) {
            return "<![" + e.getMessage() + "]!>";
        }
    }

    public String getXml() throws HopValueException {
        IValueMeta meta = this.valueMeta.clone();
        meta.setDecimalSymbol(".");
        meta.setGroupingSymbol(null);
        meta.setCurrencySymbol(null);
        StringBuilder retval = new StringBuilder(128);
        retval.append("<value>");
        retval.append(XmlHandler.addTagValue("name", meta.getName(), false, new String[0]));
        retval.append(XmlHandler.addTagValue("type", meta.getTypeDesc(), false, new String[0]));
        retval.append(XmlHandler.addTagValue("length", meta.getLength(), false));
        retval.append(XmlHandler.addTagValue("precision", meta.getPrecision(), false));
        retval.append(XmlHandler.addTagValue("mask", meta.getConversionMask(), false, new String[0]));
        try {
            retval.append(XmlHandler.addTagValue("text", meta.getCompatibleString(this.valueData), false, new String[0]));
        }
        catch (HopValueException e) {
            retval.append(XmlHandler.addTagValue("text", "", false, new String[0]));
        }
        retval.append(XmlHandler.addTagValue("isnull", meta.isNull(this.valueData), false));
        retval.append("</value>");
        return retval.toString();
    }

    public ValueMetaAndData(Node valnode) {
        this();
        this.loadXml(valnode);
    }

    public boolean loadXml(Node valnode) {
        this.valueMeta = null;
        try {
            String valname = XmlHandler.getTagValue(valnode, "name");
            int valtype = ValueMetaBase.getType(XmlHandler.getTagValue(valnode, "type"));
            String text = XmlHandler.getTagValue(valnode, "text");
            boolean isnull = "Y".equalsIgnoreCase(XmlHandler.getTagValue(valnode, "isnull"));
            int len = Const.toInt(XmlHandler.getTagValue(valnode, "length"), -1);
            int prec = Const.toInt(XmlHandler.getTagValue(valnode, "precision"), -1);
            String mask = XmlHandler.getTagValue(valnode, "mask");
            this.valueMeta = ValueMetaFactory.createValueMeta(valname, valtype, len, prec);
            this.valueData = text;
            if (mask != null) {
                this.valueMeta.setConversionMask(mask);
            }
            if (valtype != 2) {
                ValueMetaString originMeta = new ValueMetaString(valname);
                if (this.valueMeta.isNumeric()) {
                    originMeta.setDecimalSymbol(".");
                    originMeta.setGroupingSymbol(null);
                    originMeta.setCurrencySymbol(null);
                }
                if (valtype == 3) {
                    originMeta.setConversionMask("yyyy/MM/dd HH:mm:ss.SSS");
                }
                this.valueData = Const.trim(text);
                this.valueData = this.valueMeta.convertData(originMeta, this.valueData);
            }
            if (isnull) {
                this.valueData = null;
            }
        }
        catch (Exception e) {
            this.valueData = null;
            return false;
        }
        return true;
    }

    public String toStringMeta() {
        return this.valueMeta.toStringMeta();
    }

    public Object getValueData() {
        return this.valueData;
    }

    public void setValueData(Object valueData) {
        this.valueData = valueData;
    }

    public IValueMeta getValueMeta() {
        return this.valueMeta;
    }

    public void setValueMeta(IValueMeta valueMeta) {
        this.valueMeta = valueMeta;
    }
}

