/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.salesforceupdate;

import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.salesforce.SalesforceTransformMeta;
import org.apache.hop.pipeline.transforms.salesforceupdate.SalesforceUpdate;
import org.apache.hop.pipeline.transforms.salesforceupdate.SalesforceUpdateData;
import org.w3c.dom.Node;

@Transform(id="SalesforceUpdate", name="i18n::SalesforceUpdate.TypeLongDesc.SalesforceUpdate", description="i18n::SalesforceUpdate.TypeTooltipDesc.SalesforceUpdate", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Output", keywords={"i18n::SalesforceUpdateMeta.keyword"}, image="SFUD.svg", documentationUrl="/pipeline/transforms/salesforceupdate.html")
public class SalesforceUpdateMeta
extends SalesforceTransformMeta<SalesforceUpdate, SalesforceUpdateData> {
    private static final Class<?> PKG = SalesforceUpdateMeta.class;
    private String[] updateLookup;
    private Boolean[] useExternalId;
    private String[] updateStream;
    private String batchSize;
    private boolean rollbackAllChangesOnError;

    public boolean isRollbackAllChangesOnError() {
        return this.rollbackAllChangesOnError;
    }

    public void setRollbackAllChangesOnError(boolean rollbackAllChangesOnError) {
        this.rollbackAllChangesOnError = rollbackAllChangesOnError;
    }

    public String[] getUpdateLookup() {
        return this.updateLookup;
    }

    public void setUpdateLookup(String[] updateLookup) {
        this.updateLookup = updateLookup;
    }

    public Boolean[] getUseExternalId() {
        return this.useExternalId;
    }

    public void setUseExternalId(Boolean[] useExternalId) {
        this.useExternalId = useExternalId;
    }

    public String[] getUpdateStream() {
        return this.updateStream;
    }

    public void setUpdateStream(String[] updateStream) {
        this.updateStream = updateStream;
    }

    public void setBatchSize(String batchSize) {
        this.batchSize = batchSize;
    }

    public String getBatchSize() {
        return this.batchSize;
    }

    public int getBatchSizeInt() {
        return Const.toInt((String)this.batchSize, (int)10);
    }

    @Override
    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        super.loadXml(transformNode, metadataProvider);
        this.readData(transformNode);
    }

    @Override
    public Object clone() {
        SalesforceUpdateMeta retval = (SalesforceUpdateMeta)((Object)super.clone());
        int nrvalues = this.updateLookup.length;
        retval.allocate(nrvalues);
        for (int i = 0; i < nrvalues; ++i) {
            retval.updateLookup[i] = this.updateLookup[i];
            retval.updateStream[i] = this.updateStream[i];
            retval.useExternalId[i] = this.useExternalId[i];
        }
        return retval;
    }

    @Override
    public String getXml() {
        StringBuilder retval = new StringBuilder(super.getXml());
        retval.append("    " + XmlHandler.addTagValue((String)"batchSize", (String)this.getBatchSize()));
        retval.append("    <fields>" + Const.CR);
        for (int i = 0; i < this.updateLookup.length; ++i) {
            retval.append("      <field>").append(Const.CR);
            retval.append("        ").append(XmlHandler.addTagValue((String)"name", (String)this.getUpdateLookup()[i]));
            retval.append("        ").append(XmlHandler.addTagValue((String)"field", (String)this.getUpdateStream()[i]));
            retval.append("        ").append(XmlHandler.addTagValue((String)"useExternalId", (boolean)this.getUseExternalId()[i]));
            retval.append("      </field>").append(Const.CR);
        }
        retval.append("      </fields>" + Const.CR);
        retval.append("    " + XmlHandler.addTagValue((String)"rollbackAllChangesOnError", (boolean)this.isRollbackAllChangesOnError()));
        return retval.toString();
    }

    private void readData(Node transformNode) throws HopXmlException {
        try {
            this.setBatchSize(XmlHandler.getTagValue((Node)transformNode, (String)"batchSize"));
            Node fields = XmlHandler.getSubNode((Node)transformNode, (String)"fields");
            int nrFields = XmlHandler.countNodes((Node)fields, (String)"field");
            this.allocate(nrFields);
            for (int i = 0; i < nrFields; ++i) {
                String updateValue;
                Node fnode = XmlHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.updateLookup[i] = XmlHandler.getTagValue((Node)fnode, (String)"name");
                this.updateStream[i] = XmlHandler.getTagValue((Node)fnode, (String)"field");
                if (this.updateStream[i] == null) {
                    this.updateStream[i] = this.updateLookup[i];
                }
                this.useExternalId[i] = (updateValue = XmlHandler.getTagValue((Node)fnode, (String)"useExternalId")) == null ? Boolean.FALSE : (updateValue.equalsIgnoreCase("Y") ? Boolean.TRUE : Boolean.FALSE);
            }
            this.setRollbackAllChangesOnError("Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"rollbackAllChangesOnError")));
        }
        catch (Exception e) {
            throw new HopXmlException("Unable to load transform info from XML", (Throwable)e);
        }
    }

    public void allocate(int nrvalues) {
        this.setUpdateLookup(new String[nrvalues]);
        this.setUpdateStream(new String[nrvalues]);
        this.setUseExternalId(new Boolean[nrvalues]);
    }

    @Override
    public void setDefault() {
        super.setDefault();
        this.setBatchSize("10");
        this.allocate(0);
        this.setRollbackAllChangesOnError(false);
    }

    public void getFields(IRowMeta r, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
    }

    @Override
    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        super.check(remarks, pipelineMeta, transformMeta, prev, input, output, info, variables, metadataProvider);
        CheckResult cr = input != null && input.length > 0 ? new CheckResult(4, BaseMessages.getString(PKG, (String)"SalesforceUpdateMeta.CheckResult.NoInputExpected", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"SalesforceUpdateMeta.CheckResult.NoInput", (String[])new String[0]), (ICheckResultSource)transformMeta);
        remarks.add((ICheckResult)cr);
        cr = this.getUpdateLookup().length == 0 ? new CheckResult(4, BaseMessages.getString(PKG, (String)"SalesforceUpdateMeta.CheckResult.NoFields", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"SalesforceUpdateMeta.CheckResult.FieldsOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
        remarks.add((ICheckResult)cr);
    }

    public boolean supportsErrorHandling() {
        return true;
    }
}

