/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow.util;

import com.google.api.client.util.BackOff;
import com.google.api.client.util.Sleeper;
import com.google.api.services.dataflow.model.DataflowPackage;
import com.google.auto.value.AutoValue;
import com.google.cloud.hadoop.util.ApiErrorExtractor;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.beam.runners.core.construction.Environments;
import org.apache.beam.runners.dataflow.util.AutoValue_PackageUtil_PackageAttributes;
import org.apache.beam.runners.dataflow.util.AutoValue_PackageUtil_StagedFile;
import org.apache.beam.runners.dataflow.util.AutoValue_PackageUtil_StagingResult;
import org.apache.beam.sdk.extensions.gcp.storage.GcsCreateOptions;
import org.apache.beam.sdk.extensions.gcp.util.BackOffAdapter;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.fs.CreateOptions;
import org.apache.beam.sdk.io.fs.ResolveOptions;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.util.FluentBackoff;
import org.apache.beam.sdk.util.MoreFutures;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Sets;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.hash.HashCode;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.hash.Hashing;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.io.ByteSource;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.io.Files;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.util.concurrent.MoreExecutors;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;
import org.joda.time.Seconds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageUtil
implements Closeable {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(PackageUtil.class);
    private static final @UnknownKeyFor @NonNull @Initialized int SANE_CLASSPATH_SIZE = 1000;
    private static final @UnknownKeyFor @NonNull @Initialized int DEFAULT_THREAD_POOL_SIZE = 32;
    private static final @UnknownKeyFor @NonNull @Initialized Sleeper DEFAULT_SLEEPER = Sleeper.DEFAULT;
    private static final @UnknownKeyFor @NonNull @Initialized CreateOptions DEFAULT_CREATE_OPTIONS = ((GcsCreateOptions.Builder)GcsCreateOptions.builder().setGcsUploadBufferSizeBytes(Integer.valueOf(0x100000)).setMimeType("application/octet-stream")).build();
    private static final @UnknownKeyFor @NonNull @Initialized FluentBackoff BACKOFF_FACTORY = FluentBackoff.DEFAULT.withMaxRetries(4).withInitialBackoff(Duration.standardSeconds((long)5L));
    private static final @UnknownKeyFor @NonNull @Initialized ApiErrorExtractor ERROR_EXTRACTOR = new ApiErrorExtractor();
    private final @UnknownKeyFor @NonNull @Initialized ExecutorService executorService;

    private PackageUtil(@UnknownKeyFor @NonNull @Initialized ExecutorService executorService) {
        this.executorService = executorService;
    }

    public static @UnknownKeyFor @NonNull @Initialized PackageUtil withDefaultThreadPool() {
        return PackageUtil.withExecutorService((ExecutorService)MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(32, MoreExecutors.platformThreadFactory())));
    }

    public static @UnknownKeyFor @NonNull @Initialized PackageUtil withExecutorService(@UnknownKeyFor @NonNull @Initialized ExecutorService executorService) {
        return new PackageUtil(executorService);
    }

    @Override
    public void close() {
        this.executorService.shutdown();
    }

    private @UnknownKeyFor @NonNull @Initialized CompletionStage<@UnknownKeyFor @NonNull @Initialized PackageAttributes> computePackageAttributes(@UnknownKeyFor @NonNull @Initialized String source, @UnknownKeyFor @NonNull @Initialized String hash, @UnknownKeyFor @NonNull @Initialized String dest, @UnknownKeyFor @NonNull @Initialized String stagingPath) {
        return MoreFutures.supplyAsync(() -> PackageAttributes.forFileToStage(source, hash, dest, stagingPath), (ExecutorService)this.executorService);
    }

    private @UnknownKeyFor @NonNull @Initialized boolean alreadyStaged(@UnknownKeyFor @NonNull @Initialized PackageAttributes attributes) throws @UnknownKeyFor @NonNull @Initialized IOException {
        try {
            long remoteLength = FileSystems.matchSingleFileSpec((String)attributes.getDestination().getLocation()).sizeBytes();
            return remoteLength == attributes.getSize();
        }
        catch (FileNotFoundException expected) {
            return false;
        }
    }

    public @UnknownKeyFor @NonNull @Initialized CompletionStage<@UnknownKeyFor @NonNull @Initialized StagingResult> stagePackage(@UnknownKeyFor @NonNull @Initialized PackageAttributes attributes, @UnknownKeyFor @NonNull @Initialized Sleeper retrySleeper, @UnknownKeyFor @NonNull @Initialized CreateOptions createOptions) {
        return MoreFutures.supplyAsync(() -> this.stagePackageSynchronously(attributes, retrySleeper, createOptions), (ExecutorService)this.executorService);
    }

    private @UnknownKeyFor @NonNull @Initialized StagingResult stagePackageSynchronously(@UnknownKeyFor @NonNull @Initialized PackageAttributes attributes, @UnknownKeyFor @NonNull @Initialized Sleeper retrySleeper, @UnknownKeyFor @NonNull @Initialized CreateOptions createOptions) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
        String sourceDescription = attributes.getSourceDescription();
        String target = attributes.getDestination().getLocation();
        if (this.alreadyStaged(attributes)) {
            LOG.debug("Skipping file already staged: {} at {}", (Object)sourceDescription, (Object)target);
            return StagingResult.cached(attributes);
        }
        try {
            return this.tryStagePackageWithRetry(attributes, retrySleeper, createOptions);
        }
        catch (Exception miscException) {
            throw new RuntimeException(String.format("Could not stage %s to %s", sourceDescription, target), miscException);
        }
    }

    private @UnknownKeyFor @NonNull @Initialized StagingResult tryStagePackageWithRetry(@UnknownKeyFor @NonNull @Initialized PackageAttributes attributes, @UnknownKeyFor @NonNull @Initialized Sleeper retrySleeper, @UnknownKeyFor @NonNull @Initialized CreateOptions createOptions) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
        String sourceDescription = attributes.getSourceDescription();
        String target = attributes.getDestination().getLocation();
        BackOff backoff = BackOffAdapter.toGcpBackOff((org.apache.beam.sdk.util.BackOff)BACKOFF_FACTORY.backoff());
        while (true) {
            try {
                return this.tryStagePackage(attributes, createOptions);
            }
            catch (IOException ioException) {
                if (ERROR_EXTRACTOR.accessDenied(ioException)) {
                    String errorMessage = String.format("Uploaded failed due to permissions error, will NOT retry staging of %s. Please verify credentials are valid and that you have write access to %s. Stale credentials can be resolved by executing 'gcloud auth application-default login'.", sourceDescription, target);
                    LOG.error(errorMessage);
                    throw new IOException(errorMessage, ioException);
                }
                long sleep = backoff.nextBackOffMillis();
                if (sleep == -1L) {
                    LOG.error("Upload failed, will NOT retry staging of package: {}", (Object)sourceDescription, (Object)ioException);
                    throw new RuntimeException(String.format("Could not stage %s to %s", sourceDescription, target), ioException);
                }
                LOG.warn("Upload attempt failed, sleeping before retrying staging of package: {}", (Object)sourceDescription, (Object)ioException);
                retrySleeper.sleep(sleep);
                continue;
            }
            break;
        }
    }

    private @UnknownKeyFor @NonNull @Initialized StagingResult tryStagePackage(@UnknownKeyFor @NonNull @Initialized PackageAttributes attributes, @UnknownKeyFor @NonNull @Initialized CreateOptions createOptions) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
        String sourceDescription = attributes.getSourceDescription();
        String target = attributes.getDestination().getLocation();
        LOG.info("Uploading {} to {}", (Object)sourceDescription, (Object)target);
        try (WritableByteChannel writer = FileSystems.create((ResourceId)FileSystems.matchNewResource((String)target, (boolean)false), (CreateOptions)createOptions);){
            if (attributes.getBytes() != null) {
                ByteSource.wrap((byte[])attributes.getBytes()).copyTo(Channels.newOutputStream(writer));
            } else {
                File sourceFile = attributes.getSource();
                Preconditions.checkState((sourceFile != null ? 1 : 0) != 0, (String)"Internal inconsistency: we tried to stage something to %s, but neither a source file nor the byte content was specified", (Object)target);
                Files.asByteSource((File)sourceFile).copyTo(Channels.newOutputStream(writer));
            }
        }
        return StagingResult.uploaded(attributes);
    }

    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized DataflowPackage> stageClasspathElements(@UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized StagedFile> classpathElements, @UnknownKeyFor @NonNull @Initialized String stagingPath, @UnknownKeyFor @NonNull @Initialized CreateOptions createOptions) {
        return this.stageClasspathElements(classpathElements, stagingPath, DEFAULT_SLEEPER, createOptions);
    }

    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized DataflowPackage> stageClasspathElements(@UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized StagedFile> classpathElements, @UnknownKeyFor @NonNull @Initialized String stagingPath) {
        return this.stageClasspathElements(classpathElements, stagingPath, DEFAULT_SLEEPER, DEFAULT_CREATE_OPTIONS);
    }

    public @UnknownKeyFor @NonNull @Initialized DataflowPackage stageToFile(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] bytes, @UnknownKeyFor @NonNull @Initialized String target, @UnknownKeyFor @NonNull @Initialized String stagingPath, @UnknownKeyFor @NonNull @Initialized CreateOptions createOptions) {
        try {
            return ((StagingResult)MoreFutures.get(this.stagePackage(PackageAttributes.forBytesToStage(bytes, target, stagingPath), DEFAULT_SLEEPER, createOptions))).getPackageAttributes().getDestination();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted while staging pipeline", e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Error while staging pipeline", e.getCause());
        }
    }

    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized DataflowPackage> stageClasspathElements(@UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized StagedFile> classpathElements, @UnknownKeyFor @NonNull @Initialized String stagingPath, @UnknownKeyFor @NonNull @Initialized Sleeper retrySleeper, @UnknownKeyFor @NonNull @Initialized CreateOptions createOptions) {
        LOG.info("Uploading {} files from PipelineOptions.filesToStage to staging location to prepare for execution.", (Object)classpathElements.size());
        Instant start = Instant.now();
        if (classpathElements.size() > 1000) {
            LOG.warn("Your classpath contains {} elements, which Google Cloud Dataflow automatically copies to all workers. Having this many entries on your classpath may be indicative of an issue in your pipeline. You may want to consider trimming the classpath to necessary dependencies only, using --filesToStage pipeline option to override what files are being staged, or bundling several dependencies into one.", (Object)classpathElements.size());
        }
        Preconditions.checkArgument((stagingPath != null ? 1 : 0) != 0, (Object)"Can't stage classpath elements because no staging location has been provided");
        AtomicInteger numUploaded = new AtomicInteger(0);
        AtomicInteger numCached = new AtomicInteger(0);
        ArrayList<CompletionStage<DataflowPackage>> destinationPackages = new ArrayList<CompletionStage<DataflowPackage>>();
        Set distinctDestinations = Sets.newConcurrentHashSet();
        for (StagedFile classpathElement : classpathElements) {
            String dest = classpathElement.getDestination();
            String source = classpathElement.getSource();
            String hash = classpathElement.getSha256();
            File sourceFile = new File(source);
            if (!sourceFile.exists()) {
                LOG.warn("Skipping non-existent file to stage {}.", (Object)sourceFile);
                continue;
            }
            CompletionStage<DataflowPackage> stagingResult = this.computePackageAttributes(source, hash, dest, stagingPath).thenComposeAsync(packageAttributes -> {
                String destLocation = packageAttributes.getDestination().getLocation();
                if (distinctDestinations.add(destLocation)) {
                    return this.stagePackage((PackageAttributes)packageAttributes, retrySleeper, createOptions);
                }
                LOG.debug("Upload of {} skipped because it was already queued", (Object)destLocation);
                return CompletableFuture.completedFuture(StagingResult.cached(packageAttributes));
            });
            CompletionStage<DataflowPackage> stagedPackage = stagingResult.thenApply(stagingResult1 -> {
                if (stagingResult1.alreadyStaged()) {
                    numCached.incrementAndGet();
                } else {
                    numUploaded.incrementAndGet();
                }
                return stagingResult1.getPackageAttributes().getDestination();
            });
            destinationPackages.add(stagedPackage);
        }
        try {
            CompletionStage stagingFutures = MoreFutures.allAsList(destinationPackages);
            boolean finished = false;
            do {
                try {
                    MoreFutures.get((CompletionStage)stagingFutures, (long)3L, (TimeUnit)TimeUnit.MINUTES);
                    finished = true;
                }
                catch (TimeoutException e) {
                    LOG.info("Still staging {} files", (Object)classpathElements.size());
                }
            } while (!finished);
            List stagedPackages = (List)MoreFutures.get((CompletionStage)stagingFutures);
            Instant done = Instant.now();
            LOG.info("Staging files complete: {} files cached, {} files newly uploaded in {} seconds", new Object[]{numCached.get(), numUploaded.get(), Seconds.secondsBetween((ReadableInstant)start, (ReadableInstant)done).getSeconds()});
            return stagedPackages;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted while staging packages", e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Error while staging packages", e.getCause());
        }
    }

    @AutoValue
    static abstract class PackageAttributes {
        PackageAttributes() {
        }

        public static @UnknownKeyFor @NonNull @Initialized PackageAttributes forFileToStage(@UnknownKeyFor @NonNull @Initialized String source, @UnknownKeyFor @NonNull @Initialized String hash, @UnknownKeyFor @NonNull @Initialized String dest, @UnknownKeyFor @NonNull @Initialized String stagingPath) throws @UnknownKeyFor @NonNull @Initialized IOException {
            String target;
            File file = new File(source);
            if (!file.exists()) {
                throw new FileNotFoundException(String.format("Non-existent file to stage: %s", file.getAbsolutePath()));
            }
            Preconditions.checkState((!file.isDirectory() ? 1 : 0) != 0, (Object)"Source file must not be a directory.");
            switch (dest) {
                case "dataflow-worker.jar": 
                case "windmill_main": {
                    target = Environments.createStagingFileName((File)file, (HashCode)Files.asByteSource((File)file).hash(Hashing.sha256()));
                    LOG.info("Staging custom {} as {}", (Object)dest, (Object)target);
                    break;
                }
                default: {
                    target = dest;
                }
            }
            DataflowPackage destination = new DataflowPackage();
            String resourcePath = FileSystems.matchNewResource((String)stagingPath, (boolean)true).resolve(target, (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_FILE).toString();
            destination.setLocation(resourcePath);
            destination.setName(dest);
            return new AutoValue_PackageUtil_PackageAttributes(file, null, destination, file.length(), hash);
        }

        public static @UnknownKeyFor @NonNull @Initialized PackageAttributes forBytesToStage(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] bytes, @UnknownKeyFor @NonNull @Initialized String targetName, @UnknownKeyFor @NonNull @Initialized String stagingPath) {
            HashCode hashCode = Hashing.sha256().newHasher().putBytes(bytes).hash();
            long size = bytes.length;
            String target = Environments.createStagingFileName((File)new File(targetName), (HashCode)hashCode);
            String resourcePath = FileSystems.matchNewResource((String)stagingPath, (boolean)true).resolve(target, (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_FILE).toString();
            DataflowPackage targetPackage = new DataflowPackage();
            targetPackage.setName(target);
            targetPackage.setLocation(resourcePath);
            return new AutoValue_PackageUtil_PackageAttributes(null, bytes, targetPackage, size, hashCode.toString());
        }

        public @UnknownKeyFor @NonNull @Initialized PackageAttributes withPackageName(@UnknownKeyFor @NonNull @Initialized String overridePackageName) {
            DataflowPackage newDestination = new DataflowPackage();
            newDestination.setName(overridePackageName);
            newDestination.setLocation(this.getDestination().getLocation());
            return new AutoValue_PackageUtil_PackageAttributes(this.getSource(), this.getBytes(), newDestination, this.getSize(), this.getHash());
        }

        public abstract @Nullable @UnknownKeyFor @Initialized File getSource();

        public abstract @UnknownKeyFor @NonNull @Initialized byte @Nullable @UnknownKeyFor @Initialized [] getBytes();

        public abstract @UnknownKeyFor @NonNull @Initialized DataflowPackage getDestination();

        public abstract @UnknownKeyFor @NonNull @Initialized long getSize();

        public abstract @UnknownKeyFor @NonNull @Initialized String getHash();

        public @UnknownKeyFor @NonNull @Initialized String getSourceDescription() {
            if (this.getSource() != null) {
                return this.getSource().toString();
            }
            return String.format("<%s bytes, hash %s>", this.getSize(), this.getHash());
        }
    }

    @AutoValue
    static abstract class StagingResult {
        StagingResult() {
        }

        abstract @UnknownKeyFor @NonNull @Initialized PackageAttributes getPackageAttributes();

        abstract @UnknownKeyFor @NonNull @Initialized boolean alreadyStaged();

        public static @UnknownKeyFor @NonNull @Initialized StagingResult cached(@UnknownKeyFor @NonNull @Initialized PackageAttributes attributes) {
            return new AutoValue_PackageUtil_StagingResult(attributes, true);
        }

        public static @UnknownKeyFor @NonNull @Initialized StagingResult uploaded(@UnknownKeyFor @NonNull @Initialized PackageAttributes attributes) {
            return new AutoValue_PackageUtil_StagingResult(attributes, false);
        }
    }

    @AutoValue
    public static abstract class StagedFile {
        public static @UnknownKeyFor @NonNull @Initialized StagedFile of(@UnknownKeyFor @NonNull @Initialized String source, @UnknownKeyFor @NonNull @Initialized String sha256, @UnknownKeyFor @NonNull @Initialized String destination) {
            return new AutoValue_PackageUtil_StagedFile(source, sha256, destination);
        }

        public abstract @UnknownKeyFor @NonNull @Initialized String getSource();

        public abstract @UnknownKeyFor @NonNull @Initialized String getSha256();

        public abstract @UnknownKeyFor @NonNull @Initialized String getDestination();
    }
}

