/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.windowing;

import java.util.Arrays;
import java.util.List;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Joiner;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;

@Experimental(value=Experimental.Kind.TRIGGER)
public class AfterAll
extends Trigger.OnceTrigger {
    private AfterAll(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Trigger> subTriggers) {
        super(subTriggers);
        Preconditions.checkArgument((subTriggers.size() > 1 ? 1 : 0) != 0);
    }

    public static @UnknownKeyFor @NonNull @Initialized AfterAll of(Trigger.OnceTrigger ... triggers) {
        return new AfterAll(Arrays.asList(triggers));
    }

    public static @UnknownKeyFor @NonNull @Initialized AfterAll of(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Trigger> triggers) {
        return new AfterAll(triggers);
    }

    @Override
    @Internal
    public @UnknownKeyFor @NonNull @Initialized Instant getWatermarkThatGuaranteesFiring(@UnknownKeyFor @NonNull @Initialized BoundedWindow window) {
        Instant deadline = BoundedWindow.TIMESTAMP_MIN_VALUE;
        for (Trigger subTrigger : this.subTriggers) {
            Instant subDeadline = subTrigger.getWatermarkThatGuaranteesFiring(window);
            if (!deadline.isBefore((ReadableInstant)subDeadline)) continue;
            deadline = subDeadline;
        }
        return deadline;
    }

    @Override
    protected @UnknownKeyFor @NonNull @Initialized Trigger.OnceTrigger getContinuationTrigger(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Trigger> continuationTriggers) {
        return new AfterAll(continuationTriggers);
    }

    @Override
    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        StringBuilder builder = new StringBuilder("AfterAll.of(");
        Joiner.on((String)", ").appendTo(builder, (Iterable)this.subTriggers);
        builder.append(")");
        return builder.toString();
    }
}

