/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.testing;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.beam.sdk.testing.SerializableMatcher;
import org.apache.beam.sdk.util.FluentBackoff;
import org.apache.beam.sdk.util.ShardedFile;
import org.apache.beam.sdk.util.Sleeper;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Strings;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.hash.HashCode;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.hash.Hashing;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileChecksumMatcher
extends TypeSafeMatcher<ShardedFile>
implements SerializableMatcher<ShardedFile> {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(FileChecksumMatcher.class);
    static final @UnknownKeyFor @NonNull @Initialized int MAX_READ_RETRIES = 4;
    static final @UnknownKeyFor @NonNull @Initialized Duration DEFAULT_SLEEP_DURATION = Duration.standardSeconds((long)10L);
    static final @UnknownKeyFor @NonNull @Initialized FluentBackoff BACK_OFF_FACTORY = FluentBackoff.DEFAULT.withInitialBackoff(DEFAULT_SLEEP_DURATION).withMaxRetries(4);
    private final @UnknownKeyFor @NonNull @Initialized String expectedChecksum;
    private @UnknownKeyFor @NonNull @Initialized String actualChecksum;

    private FileChecksumMatcher(@UnknownKeyFor @NonNull @Initialized String checksum) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)checksum) ? 1 : 0) != 0, (String)"Expected valid checksum, but received %s", (Object)checksum);
        this.expectedChecksum = checksum;
    }

    public static @UnknownKeyFor @NonNull @Initialized FileChecksumMatcher fileContentsHaveChecksum(@UnknownKeyFor @NonNull @Initialized String checksum) {
        return new FileChecksumMatcher(checksum);
    }

    public @UnknownKeyFor @NonNull @Initialized boolean matchesSafely(@UnknownKeyFor @NonNull @Initialized ShardedFile shardedFile) {
        return this.getActualChecksum(shardedFile).equals(this.expectedChecksum);
    }

    private @UnknownKeyFor @NonNull @Initialized String getActualChecksum(@UnknownKeyFor @NonNull @Initialized ShardedFile shardedFile) {
        List<String> outputs;
        try {
            outputs = shardedFile.readFilesWithRetries(Sleeper.DEFAULT, BACK_OFF_FACTORY.backoff());
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Failed to read from: %s", shardedFile), e);
        }
        this.actualChecksum = FileChecksumMatcher.computeHash(outputs);
        LOG.debug("Generated checksum: {}", (Object)this.actualChecksum);
        return this.actualChecksum;
    }

    private static @UnknownKeyFor @NonNull @Initialized String computeHash(@Nonnull @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> strs) {
        if (strs.isEmpty()) {
            return Hashing.sha1().hashString((CharSequence)"", StandardCharsets.UTF_8).toString();
        }
        ArrayList<HashCode> hashCodes = new ArrayList<HashCode>();
        for (String str : strs) {
            hashCodes.add(Hashing.sha1().hashString((CharSequence)str, StandardCharsets.UTF_8));
        }
        return Hashing.combineUnordered(hashCodes).toString();
    }

    public void describeTo(@UnknownKeyFor @NonNull @Initialized Description description) {
        description.appendText("Expected checksum is (").appendText(this.expectedChecksum).appendText(")");
    }

    public void describeMismatchSafely(@UnknownKeyFor @NonNull @Initialized ShardedFile shardedFile, @UnknownKeyFor @NonNull @Initialized Description description) {
        description.appendText("was (").appendText(this.actualChecksum).appendText(")");
    }
}

