/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import java.io.Closeable;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import junit.extensions.TestSetup;
import junit.framework.Test;

public class ClasspathSetup
extends TestSetup {
    private URL _resource;
    private ClassLoader _originalClassLoader;
    private URLClassLoader _newClassLoader;

    public ClasspathSetup(Test test, URL resource) {
        super(test);
        this._resource = resource;
    }

    protected void setUp() {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                ClasspathSetup.this._originalClassLoader = Thread.currentThread().getContextClassLoader();
                ClasspathSetup.this._newClassLoader = new URLClassLoader(new URL[]{ClasspathSetup.this._resource}, ClasspathSetup.this._originalClassLoader);
                Thread.currentThread().setContextClassLoader(ClasspathSetup.this._newClassLoader);
                return null;
            }
        });
    }

    protected void tearDown() throws Exception {
        AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws IOException {
                Thread.currentThread().setContextClassLoader(ClasspathSetup.this._originalClassLoader);
                if (ClasspathSetup.this._newClassLoader instanceof Closeable) {
                    ClasspathSetup.this._newClassLoader.close();
                }
                return null;
            }
        });
        this._originalClassLoader = null;
        this._newClassLoader = null;
        this._resource = null;
    }

    public static boolean supportsClose() {
        return Closeable.class.isAssignableFrom(URLClassLoader.class);
    }
}

