/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input.buffer;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import org.apache.commons.io.input.buffer.CircularBufferInputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class CircularBufferInputStreamTest {
    private final Random random = new Random(1530960934483L);

    CircularBufferInputStreamTest() {
    }

    void asssertNotEof(int offset, int res) {
        Assertions.assertNotEquals((int)-1, (int)res, () -> "Unexpected EOF at offset " + offset);
    }

    private byte[] newInputBuffer() {
        byte[] buffer = new byte[8192 + this.random.nextInt(512)];
        this.random.nextBytes(buffer);
        return buffer;
    }

    @Test
    void testIO683() throws IOException {
        byte[] buffer = new byte[]{0, 1, -2, -2, -1, 4};
        try (ByteArrayInputStream bais = new ByteArrayInputStream(buffer);
             CircularBufferInputStream cbis = new CircularBufferInputStream((InputStream)bais);){
            int b;
            int i = 0;
            while ((b = cbis.read()) != -1) {
                Assertions.assertEquals((int)(buffer[i] & 0xFF), (int)b, (String)("byte at index " + i + " should be equal"));
                ++i;
            }
            Assertions.assertEquals((int)buffer.length, (int)i, (String)"Should have read all the bytes");
        }
    }

    @Test
    void testRandomRead() throws Exception {
        byte[] inputBuffer = this.newInputBuffer();
        byte[] bufferCopy = new byte[inputBuffer.length];
        ByteArrayInputStream bais = new ByteArrayInputStream(inputBuffer);
        CircularBufferInputStream cbis = new CircularBufferInputStream((InputStream)bais, 253);
        int offset = 0;
        byte[] readBuffer = new byte[256];
        block4: while (offset < bufferCopy.length) {
            switch (this.random.nextInt(2)) {
                case 0: {
                    int res = cbis.read();
                    this.asssertNotEof(offset, res);
                    Assertions.assertEquals((byte)inputBuffer[offset], (byte)((byte)res), (String)("Expected " + inputBuffer[offset] + " at offset " + offset + ", got " + res));
                    ++offset;
                    continue block4;
                }
                case 1: {
                    int res = cbis.read(readBuffer, 0, this.random.nextInt(readBuffer.length + 1));
                    this.asssertNotEof(offset, res);
                    Assertions.assertNotEquals((int)0, (int)res, (String)("Unexpected zero-byte-result at offset " + offset));
                    for (int i = 0; i < res; ++i) {
                        Assertions.assertEquals((byte)inputBuffer[offset], (byte)readBuffer[i], (String)("Expected " + inputBuffer[offset] + " at offset " + offset + ", got " + readBuffer[i]));
                        ++offset;
                    }
                    continue block4;
                }
            }
            Assertions.fail((String)"Unexpected random choice value");
        }
        Assertions.assertTrue((boolean)true, (String)"Test finished OK");
    }
}

