/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.file.AbstractTempDirTest;
import org.apache.commons.io.file.DeleteOption;
import org.apache.commons.io.file.PathUtils;
import org.apache.commons.io.file.StandardDeleteOption;
import org.apache.commons.io.function.IOConsumer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.WINDOWS})
class DeleteDirectoryTest
extends AbstractTempDirTest {
    DeleteDirectoryTest() {
    }

    private void testDeleteDirectory(IOConsumer<Path> deleter) throws IOException {
        String contents = "Hello!";
        Path file = this.tempDirPath.resolve("file.txt");
        Charset charset = StandardCharsets.UTF_8;
        PathUtils.writeString((Path)file, (CharSequence)"Hello!", (Charset)charset, (OpenOption[])new OpenOption[0]);
        Set<PosixFilePermission> permissions = Files.getPosixFilePermissions(file, new LinkOption[0]);
        Assertions.assertTrue((boolean)permissions.contains((Object)PosixFilePermission.OWNER_WRITE), (Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, toString(), ()Ljava/lang/String;)(permissions));
        Path testDir = this.tempDirPath.resolve("dir");
        Files.createDirectory(testDir, new FileAttribute[0]);
        Path symLink = testDir.resolve("symlink.txt");
        Files.createSymbolicLink(symLink, file, new FileAttribute[0]);
        Assertions.assertEquals((Object)"Hello!", (Object)PathUtils.readString((Path)symLink, (Charset)charset));
        deleter.accept((Object)testDir);
        Assertions.assertFalse((boolean)Files.exists(symLink, new LinkOption[0]), symLink::toString);
        Assertions.assertTrue((boolean)Files.exists(file, new LinkOption[0]), file::toString);
        Assertions.assertEquals(permissions, Files.getPosixFilePermissions(file, new LinkOption[0]), file::toString);
    }

    @Test
    void testDeleteDirectoryWithFileUtils() throws IOException {
        this.testDeleteDirectory((IOConsumer<Path>)((IOConsumer)dir -> FileUtils.deleteDirectory((File)dir.toFile())));
    }

    @Test
    void testDeleteDirectoryWithPathUtils() throws IOException {
        this.testDeleteDirectory((IOConsumer<Path>)((IOConsumer)PathUtils::deleteDirectory));
    }

    @Test
    void testDeleteDirectoryWithPathUtilsOverrideReadOnly() throws IOException {
        this.testDeleteDirectory((IOConsumer<Path>)((IOConsumer)dir -> PathUtils.deleteDirectory((Path)dir, (DeleteOption[])new DeleteOption[]{StandardDeleteOption.OVERRIDE_READ_ONLY})));
    }

    @Test
    @DisabledOnOs(value={OS.LINUX})
    void testDeleteFileCheckParentAccess() throws IOException {
        Path testDir = this.tempDirPath.resolve("dir");
        Files.createDirectory(testDir, new FileAttribute[0]);
        Path file = testDir.resolve("file.txt");
        Charset charset = StandardCharsets.UTF_8;
        PathUtils.writeString((Path)file, (CharSequence)"Hello!", (Charset)charset, (OpenOption[])new OpenOption[0]);
        PathUtils.setReadOnly((Path)file, (boolean)true, (LinkOption[])new LinkOption[0]);
        Set<PosixFilePermission> permissions = Files.getPosixFilePermissions(testDir, new LinkOption[0]);
        Assertions.assertFalse((boolean)Files.isWritable(testDir), () -> String.format("Parent directory '%s' of '%s' should NOT be Writable, permissions are %s ", testDir, file, permissions));
        Assertions.assertFalse((boolean)Files.isExecutable(testDir), () -> String.format("Parent directory '%s' of '%s' should NOT be Executable, permissions are %s ", testDir, file, permissions));
        Assertions.assertThrows(IOException.class, () -> PathUtils.delete((Path)file));
        PathUtils.delete((Path)file, (DeleteOption[])new DeleteOption[]{StandardDeleteOption.OVERRIDE_READ_ONLY});
        Assertions.assertFalse((boolean)Files.exists(file, new LinkOption[0]));
        Assertions.assertEquals(permissions, Files.getPosixFilePermissions(testDir, new LinkOption[0]), testDir::toString);
        Assertions.assertFalse((boolean)Files.isWritable(testDir));
        Assertions.assertFalse((boolean)Files.isExecutable(testDir));
    }
}

