/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.rewriter.rules.subplan;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.AlgebricksBuiltinFunctions;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.GroupByOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SelectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SubplanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class SubplanOutOfGroupRule
implements IAlgebraicRewriteRule {
    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        return false;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator subplan;
        ILogicalOperator op2;
        AbstractLogicalOperator op0 = (AbstractLogicalOperator)opRef.getValue();
        if (op0.getOperatorTag() != LogicalOperatorTag.GROUP) {
            return false;
        }
        GroupByOperator gby = (GroupByOperator)op0;
        Iterator plansIter = gby.getNestedPlans().iterator();
        ILogicalPlan p = null;
        while (plansIter.hasNext()) {
            p = (ILogicalPlan)plansIter.next();
        }
        if (p == null) {
            return false;
        }
        if (p.getRoots().size() != 1) {
            return false;
        }
        Mutable op1Ref = (Mutable)p.getRoots().get(0);
        AbstractLogicalOperator op1 = (AbstractLogicalOperator)op1Ref.getValue();
        boolean found = false;
        while (op1.getInputs().size() == 1) {
            AbstractLogicalOperator r1;
            ILogicalPlan p1;
            if (op1.getOperatorTag() == LogicalOperatorTag.SUBPLAN && SubplanOutOfGroupRule.isMissingTest((AbstractLogicalOperator)(op2 = (AbstractLogicalOperator)((Mutable)(subplan = (SubplanOperator)op1).getInputs().get(0)).getValue())) && subplan.getNestedPlans().size() == 1 && (p1 = (ILogicalPlan)subplan.getNestedPlans().get(0)).getRoots().size() == 1 && ((r1 = (AbstractLogicalOperator)((Mutable)p1.getRoots().get(0)).getValue()).getOperatorTag() == LogicalOperatorTag.INNERJOIN || r1.getOperatorTag() == LogicalOperatorTag.LEFTOUTERJOIN)) {
                ArrayList op2Vars = new ArrayList();
                VariableUtilities.getLiveVariables((ILogicalOperator)op2, op2Vars);
                ArrayList op1Vars = new ArrayList();
                VariableUtilities.getLiveVariables((ILogicalOperator)subplan, op1Vars);
                if (op1Vars.containsAll(op2Vars)) {
                    found = true;
                    break;
                }
            }
            op1Ref = (Mutable)op1.getInputs().get(0);
            op1 = (AbstractLogicalOperator)op1Ref.getValue();
        }
        if (!found) {
            return false;
        }
        subplan = op1;
        op2 = (ILogicalOperator)((Mutable)op1.getInputs().get(0)).getValue();
        op1Ref.setValue((Object)op2);
        Mutable opUnderRef = (Mutable)gby.getInputs().get(0);
        ILogicalOperator opUnder = (ILogicalOperator)opUnderRef.getValue();
        subplan.getInputs().clear();
        subplan.getInputs().add(new MutableObject((Object)opUnder));
        opUnderRef.setValue((Object)subplan);
        return true;
    }

    private static boolean isMissingTest(AbstractLogicalOperator op) {
        if (op.getOperatorTag() != LogicalOperatorTag.SELECT) {
            return false;
        }
        AbstractLogicalOperator doubleUnder = (AbstractLogicalOperator)((Mutable)op.getInputs().get(0)).getValue();
        if (doubleUnder.getOperatorTag() != LogicalOperatorTag.NESTEDTUPLESOURCE) {
            return false;
        }
        ILogicalExpression eu = (ILogicalExpression)((SelectOperator)op).getCondition().getValue();
        if (eu.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
            return false;
        }
        AbstractFunctionCallExpression f1 = (AbstractFunctionCallExpression)eu;
        if (!f1.getFunctionIdentifier().equals((Object)AlgebricksBuiltinFunctions.NOT)) {
            return false;
        }
        ILogicalExpression a1 = (ILogicalExpression)((Mutable)f1.getArguments().get(0)).getValue();
        if (!a1.getExpressionTag().equals((Object)LogicalExpressionTag.FUNCTION_CALL)) {
            return false;
        }
        AbstractFunctionCallExpression f2 = (AbstractFunctionCallExpression)a1;
        return f2.getFunctionIdentifier().equals((Object)AlgebricksBuiltinFunctions.IS_MISSING);
    }
}

