/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.common.util;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.ILangExpression;
import org.apache.asterix.lang.common.expression.GbyVariableExpressionPair;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.rewrites.LangRewritingContext;
import org.apache.asterix.lang.common.rewrites.VariableSubstitutionEnvironment;
import org.apache.asterix.lang.common.struct.Identifier;
import org.apache.asterix.lang.common.visitor.CloneAndSubstituteVariablesVisitor;
import org.apache.hyracks.algebricks.common.utils.Pair;

public class VariableCloneAndSubstitutionUtil {
    private VariableCloneAndSubstitutionUtil() {
    }

    public static List<GbyVariableExpressionPair> substInVarExprPair(LangRewritingContext context, List<GbyVariableExpressionPair> gbyVeList, VariableSubstitutionEnvironment newSubs, CloneAndSubstituteVariablesVisitor visitor) throws CompilationException {
        VariableSubstitutionEnvironment subs = newSubs;
        LinkedList<GbyVariableExpressionPair> veList = new LinkedList<GbyVariableExpressionPair>();
        for (GbyVariableExpressionPair vep : gbyVeList) {
            VariableExpr oldGbyVar = vep.getVar();
            VariableExpr newGbyVar = null;
            if (oldGbyVar != null) {
                newGbyVar = visitor.generateNewVariable(context, oldGbyVar);
                subs = VariableCloneAndSubstitutionUtil.eliminateSubstFromList(newGbyVar, subs);
            }
            Pair<ILangExpression, VariableSubstitutionEnvironment> p1 = vep.getExpr().accept(visitor, subs);
            GbyVariableExpressionPair ve2 = new GbyVariableExpressionPair(newGbyVar, (Expression)p1.first);
            veList.add(ve2);
        }
        return veList;
    }

    public static List<Pair<Expression, Identifier>> substInFieldList(List<Pair<Expression, Identifier>> fieldList, VariableSubstitutionEnvironment newSubs, CloneAndSubstituteVariablesVisitor visitor) throws CompilationException {
        ArrayList<Pair<Expression, Identifier>> newFieldList = new ArrayList<Pair<Expression, Identifier>>(fieldList.size());
        for (Pair<Expression, Identifier> p : fieldList) {
            Expression newExpr = (Expression)((Expression)p.first).accept(visitor, newSubs).first;
            newFieldList.add((Pair<Expression, Identifier>)new Pair((Object)newExpr, (Object)((Identifier)p.second)));
        }
        return newFieldList;
    }

    public static VariableSubstitutionEnvironment eliminateSubstFromList(VariableExpr variableExpr, VariableSubstitutionEnvironment arg) {
        VariableSubstitutionEnvironment newArg = new VariableSubstitutionEnvironment(arg);
        newArg.removeSubstitution(variableExpr);
        return newArg;
    }

    public static List<Expression> visitAndCloneExprList(List<Expression> oldExprList, VariableSubstitutionEnvironment arg, CloneAndSubstituteVariablesVisitor visitor) throws CompilationException {
        ArrayList<Expression> exprs = new ArrayList<Expression>(oldExprList.size());
        for (Expression e : oldExprList) {
            Pair<ILangExpression, VariableSubstitutionEnvironment> p1 = e.accept(visitor, arg);
            exprs.add((Expression)p1.first);
        }
        return exprs;
    }
}

