/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http.servlet;

import javax.servlet.http.HttpServletRequest;
import org.apache.wicket.protocol.http.servlet.DispatchedRequestUtils;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.Strings;

public class ForwardAttributes {
    private final String requestUri;
    private final String servletPath;
    private final String contextPath;
    private final String queryString;
    private final String pathInfo;

    private ForwardAttributes(String requestUri, String servletPath, String contextPath, String queryString, String pathInfo) {
        this.requestUri = requestUri;
        this.servletPath = servletPath;
        this.contextPath = contextPath;
        this.queryString = queryString;
        this.pathInfo = pathInfo;
    }

    public String getRequestUri() {
        return this.requestUri;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public static ForwardAttributes of(HttpServletRequest request, String filterPrefix) {
        Args.notNull(request, "request");
        String requestUri = DispatchedRequestUtils.getRequestUri(request, "javax.servlet.forward.request_uri", filterPrefix);
        String servletPath = (String)request.getAttribute("javax.servlet.forward.servlet_path");
        String contextPath = (String)request.getAttribute("javax.servlet.forward.context_path");
        String queryString = (String)request.getAttribute("javax.servlet.forward.query_string");
        String pathInfo = (String)request.getAttribute("javax.servlet.forward.path_info");
        if (!(Strings.isEmpty(requestUri) && Strings.isEmpty(servletPath) && Strings.isEmpty(contextPath) && Strings.isEmpty(queryString) && Strings.isEmpty(pathInfo))) {
            return new ForwardAttributes(requestUri, servletPath, contextPath, queryString, pathInfo);
        }
        return null;
    }

    public String toString() {
        return "ForwardAttributes [requestUri=" + this.requestUri + ", servletPath=" + this.servletPath + ", contextPath=" + this.contextPath + ", queryString=" + this.queryString + ", pathInfo=" + this.pathInfo + "]";
    }
}

