/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.action;

import java.util.List;
import org.apache.uima.UimaContextHolder;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.action.TypeSensitiveAction;
import org.apache.uima.ruta.expression.type.ITypeExpression;
import org.apache.uima.ruta.rule.MatchContext;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.rule.RuleElementMatch;
import org.apache.uima.ruta.rule.RuleMatch;
import org.apache.uima.ruta.visitor.InferenceCrowd;

public class TransferAction
extends TypeSensitiveAction {
    public TransferAction(ITypeExpression type) {
        super(type);
    }

    @Override
    public void execute(MatchContext context, RutaStream stream, InferenceCrowd crowd) {
        RuleMatch match = context.getRuleMatch();
        RuleElement element = context.getElement();
        List<List<RuleElementMatch>> list = match.getMatchInfo(element);
        CAS cas = stream.getCas();
        Type t = this.type.getType(context, stream);
        if (t == null) {
            return;
        }
        for (List<RuleElementMatch> eachList : list) {
            for (RuleElementMatch each : eachList) {
                List<AnnotationFS> matched = each.getTextsMatched();
                for (AnnotationFS annotationFS : matched) {
                    FeatureStructure createFS = cas.createFS(t);
                    this.copyFeatures(annotationFS, createFS, cas);
                    if (createFS instanceof AnnotationFS) {
                        stream.addAnnotation((AnnotationFS)createFS, match);
                        this.addAnnotationToLabel((AnnotationFS)createFS, context);
                    }
                    cas.addFsToIndexes(createFS);
                }
            }
        }
    }

    private void copyFeatures(AnnotationFS oldFS, FeatureStructure newFS, CAS cas) {
        List features = oldFS.getType().getFeatures();
        Type newType = newFS.getType();
        for (Object object : features) {
            String value;
            Feature feature = (Feature)object;
            String shortName = feature.getShortName();
            Feature newFeature = newType.getFeatureByBaseName(shortName);
            if (newFeature == null) continue;
            if (feature.getRange().isPrimitive()) {
                value = oldFS.getFeatureValueAsString(feature);
                try {
                    newFS.setFeatureValueFromString(newFeature, value);
                }
                catch (Exception e) {
                    UimaContextHolder.getContext().getLogger().debug("Unable to transfer feature {}: {}", (Object)shortName, (Object)e.getMessage());
                }
                continue;
            }
            value = oldFS.getFeatureValue(feature);
            try {
                newFS.setFeatureValue(newFeature, (FeatureStructure)value);
            }
            catch (Exception e) {
                UimaContextHolder.getContext().getLogger().debug("Unable to transfer feature {}: {}", (Object)shortName, (Object)e.getMessage());
            }
        }
    }
}

