/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.netcdf.base;

import java.util.Collection;
import java.util.Locale;
import org.apache.sis.math.DecimalFunctions;
import org.apache.sis.math.Vector;
import org.apache.sis.storage.netcdf.base.Decoder;
import org.apache.sis.storage.netcdf.base.NamedElement;
import org.apache.sis.storage.netcdf.internal.Resources;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.internal.Strings;
import org.apache.sis.util.resources.Errors;

public abstract class Node
extends NamedElement {
    protected final Decoder decoder;

    protected Node(Decoder decoder) {
        this.decoder = decoder;
    }

    public abstract Collection<String> getAttributeNames();

    public abstract Class<?> getAttributeType(String var1);

    protected abstract Object getAttributeValue(String var1);

    public final String getAttributeAsString(String attributeName) {
        Object value = this.getAttributeValue(attributeName);
        if (value == null || value instanceof String) {
            return (String)value;
        }
        String[] values = Node.toArray(value);
        if (values == null) {
            return value.toString();
        }
        String singleton = null;
        for (String c : values) {
            if (c == null) continue;
            if (singleton == null) {
                singleton = c;
                continue;
            }
            if (singleton.equals(c)) continue;
            return null;
        }
        return singleton;
    }

    public final CharSequence[] getAttributeAsStrings(String attributeName, char separator) {
        Object value = this.getAttributeValue(attributeName);
        if (value != null) {
            CharSequence[] ts = Node.toArray(value);
            if (ts == null) {
                ts = CharSequences.split(value.toString(), separator);
            }
            if (ts.length != 0) {
                return ts;
            }
        }
        return null;
    }

    private static String[] toArray(Object value) {
        int i;
        String[] array;
        Object values;
        if (value instanceof String[]) {
            return (String[])value;
        }
        if (value instanceof Object[]) {
            values = (Object[])value;
            array = new String[((Object[])values).length];
            for (i = 0; i < array.length; ++i) {
                Object e = values[i];
                if (e == null) continue;
                array[i] = e.toString();
            }
        } else if (value instanceof Vector) {
            values = (Vector)value;
            array = new String[((Vector)values).size()];
            for (i = 0; i < array.length; ++i) {
                array[i] = ((Vector)values).stringValue(i);
            }
        } else {
            return null;
        }
        boolean hasValues = false;
        for (i = 0; i < array.length; ++i) {
            array[i] = Strings.trimOrNull(array[i]);
            hasValues |= array[i] != null;
        }
        return hasValues ? array : null;
    }

    public final Number getAttributeAsNumber(String attributeName) {
        Number singleton = null;
        Object value = this.getAttributeValue(attributeName);
        if (value instanceof Number) {
            singleton = (Number)value;
        } else if (value instanceof String) {
            singleton = this.decoder.parseNumber(attributeName, (String)value);
        } else if (value instanceof Vector) {
            Vector data = (Vector)value;
            int length = data.size();
            for (int i = 0; i < length; ++i) {
                Number n = data.get(i);
                if (n == null) continue;
                if (singleton == null) {
                    singleton = n;
                    continue;
                }
                if (singleton.equals(n)) continue;
                return null;
            }
        }
        return singleton;
    }

    public final double getAttributeAsDouble(String attributeName) {
        Number singleton = this.getAttributeAsNumber(attributeName);
        if (singleton == null) {
            return Double.NaN;
        }
        double dp = singleton.doubleValue();
        float sp = (float)dp;
        if ((double)sp == dp) {
            dp = DecimalFunctions.floatToDouble(sp);
        }
        return dp;
    }

    public final Vector getAttributeAsVector(String attributeName) {
        Object value = this.getAttributeValue(attributeName);
        if (value instanceof Vector) {
            return (Vector)value;
        }
        if (value instanceof Float) {
            return Vector.createForDecimal(new float[]{((Float)value).floatValue()});
        }
        if (value instanceof Number) {
            return Vector.create(new Number[]{(Number)value}, false);
        }
        return null;
    }

    protected final Locale getLocale() {
        return this.decoder.listeners.getLocale();
    }

    protected final Resources resources() {
        return Resources.forLocale(this.getLocale());
    }

    final Errors errors() {
        return Errors.getResources(this.getLocale());
    }

    protected final void warning(Class<?> caller, String method, short key, Object ... arguments) {
        Node.warning(this.decoder.listeners, caller, method, null, null, key, arguments);
    }

    protected final void error(Class<?> caller, String method, Exception exception, short key, Object ... arguments) {
        Node.warning(this.decoder.listeners, caller, method, exception, this.errors(), key, arguments);
    }
}

