/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.batch.fs;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.ArrayBlockingQueue;
import org.apache.tika.batch.FileResource;
import org.apache.tika.batch.FileResourceCrawler;
import org.apache.tika.batch.fs.FSFileResource;

public class FSListCrawler
extends FileResourceCrawler {
    private final BufferedReader reader;
    private final Path root;

    public FSListCrawler(ArrayBlockingQueue<FileResource> fileQueue, int numConsumers, Path root, Path list, Charset charset) throws IOException {
        super(fileQueue, numConsumers);
        this.reader = Files.newBufferedReader(list, charset);
        this.root = root;
    }

    @Override
    public void start() throws InterruptedException {
        String line = this.nextLine();
        while (line != null) {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException("file adder interrupted");
            }
            Path f = Paths.get(this.root.toString(), line);
            if (!Files.exists(f, new LinkOption[0])) {
                LOG.warn("File doesn't exist: {}", (Object)f.toAbsolutePath());
                line = this.nextLine();
                continue;
            }
            if (Files.isDirectory(f, new LinkOption[0])) {
                LOG.warn("File is a directory: {}", (Object)f.toAbsolutePath());
                line = this.nextLine();
                continue;
            }
            this.tryToAdd(new FSFileResource(this.root, f));
            line = this.nextLine();
        }
    }

    private String nextLine() {
        String line = null;
        try {
            line = this.reader.readLine();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return line;
    }
}

