/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.util.iso.Types;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.maintenance.ScopeCode;
import org.opengis.util.InternationalString;

@XmlType(name="MD_MetadataScope_Type", propOrder={"resourceScope", "name"})
@XmlRootElement(name="MD_MetadataScope")
@UML(identifier="MD_MetadataScope", specification=Specification.ISO_19115)
public class DefaultMetadataScope
extends ISOMetadata {
    private static final long serialVersionUID = -7186722085106176683L;
    private ScopeCode resourceScope;
    private InternationalString name;

    public DefaultMetadataScope() {
    }

    public DefaultMetadataScope(ScopeCode resourceScope, CharSequence name) {
        this.resourceScope = resourceScope;
        this.name = Types.toInternationalString(name);
    }

    public DefaultMetadataScope(DefaultMetadataScope object) {
        super(object);
        if (object != null) {
            this.resourceScope = object.getResourceScope();
            this.name = object.getName();
        }
    }

    @XmlElement(name="resourceScope", required=true)
    @UML(identifier="resourceScope", obligation=Obligation.MANDATORY, specification=Specification.ISO_19115)
    public ScopeCode getResourceScope() {
        return this.resourceScope;
    }

    public void setResourceScope(ScopeCode newValue) {
        this.checkWritePermission(this.resourceScope);
        this.resourceScope = newValue;
    }

    @XmlElement(name="name")
    @UML(identifier="name", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public InternationalString getName() {
        return this.name;
    }

    public void setName(InternationalString newValue) {
        this.checkWritePermission(this.name);
        this.name = newValue;
    }
}

