/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage;

import java.util.Locale;
import org.apache.sis.io.stream.IOUtilities;
import org.apache.sis.storage.internal.Resources;
import org.apache.sis.util.LocalizedException;
import org.opengis.util.InternationalString;

public class DataStoreException
extends Exception
implements LocalizedException {
    private static final long serialVersionUID = -1778987176103191950L;
    private transient short key;
    private transient Object[] parameters;

    public DataStoreException() {
    }

    public DataStoreException(String message) {
        super(message);
    }

    public DataStoreException(Throwable cause) {
        super(cause);
    }

    public DataStoreException(String message, Throwable cause) {
        super(message, cause);
    }

    public DataStoreException(Locale locale, String format, String filename, Object store) {
        this(locale, IOUtilities.errorMessageParameters(format, filename, store));
    }

    private DataStoreException(Locale locale, Object[] params) {
        this(locale, IOUtilities.errorMessageKey(params), params);
    }

    DataStoreException(Locale locale, short key, Object ... parameters) {
        super(Resources.forLocale(locale).getString(key, parameters));
        this.key = key;
        this.parameters = parameters;
    }

    @Override
    public String getMessage() {
        return this.key != 0 ? Resources.format(this.key, this.parameters) : super.getMessage();
    }

    @Override
    public String getLocalizedMessage() {
        return super.getMessage();
    }

    public InternationalString getInternationalMessage() {
        return this.key != 0 ? Resources.formatInternational(this.key, this.parameters) : null;
    }

    @Override
    public DataStoreException initCause(Throwable cause) {
        return (DataStoreException)super.initCause(cause);
    }
}

