//>>built
define("dojox/app/controllers/HistoryHash",["dojo/_base/lang","dojo/_base/declare","dojo/topic","dojo/on","../Controller","../utils/hash","dojo/hash"],function(_1,_2,_3,on,_4,_5){
return _2("dojox.app.controllers.HistoryHash",_4,{constructor:function(_6){
this.events={"app-domNode":this.onDomNodeChange};
if(this.app.domNode){
this.onDomNodeChange({oldNode:null,newNode:this.app.domNode});
}
_3.subscribe("/dojo/hashchange",_1.hitch(this,function(_7){
this._onHashChange(_7);
}));
this._historyStack=[];
this._historyLen=0;
this._historyDiff=0;
this._current=null;
this._next=null;
this._previous=null;
this._index=0;
this._oldHistoryLen=0;
this._newHistoryLen=0;
this._addToHistoryStack=false;
this._startTransitionEvent=false;
var _8=window.location.hash;
if(_8&&(_8.length>1)){
_8=_8.substr(1);
}
this._historyStack.push({"hash":_8,"url":window.location.href,"detail":{target:_8}});
this._historyLen=window.history.length;
this._index=this._historyStack.length-1;
this._current=_8;
this._historyDiff=window.history.length-this._historyStack.length;
},onDomNodeChange:function(_9){
if(_9.oldNode!=null){
this.unbind(_9.oldNode,"startTransition");
}
this.bind(_9.newNode,"startTransition",_1.hitch(this,this.onStartTransition));
},onStartTransition:function(_a){
var _b=_a.detail.target;
var _c=/#(.+)/;
if(!_b&&_c.test(_a.detail.href)){
_b=_a.detail.href.match(_c)[1];
}
var _d=_a.detail.url||"#"+_b;
if(_a.detail.params){
_d=_5.buildWithParams(_d,_a.detail.params);
}
this._oldHistoryLen=window.history.length;
window.location.hash=_d;
this._addToHistoryStack=true;
this._startTransitionEvent=true;
},_addHistory:function(_e){
this._historyStack.push({"hash":_e,"url":window.location.href,"detail":{target:_e}});
this._historyLen=window.history.length;
this._index=this._historyStack.length-1;
this._previous=this._current;
this._current=_e;
this._next=null;
this._historyDiff=window.history.length-this._historyStack.length;
this._addToHistoryStack=false;
},_onHashChange:function(_f){
if(this._index<0||this._index>(window.history.length-1)){
throw Error("Application history out of management.");
}
this._newHistoryLen=window.history.length;
if(this._oldHistoryLen>this._newHistoryLen){
this._historyStack.splice((this._newHistoryLen-this._historyDiff-1),(this._historyStack.length-1));
this._historyLen=this._historyStack.length;
this._oldHistoryLen=0;
}
if(this._addToHistoryStack&&(this._oldHistoryLen===this._newHistoryLen)){
this._historyStack.splice((this._newHistoryLen-this._historyDiff-1),(this._historyStack.length-1));
this._addHistory(_f);
return;
}
if(this._historyLen<window.history.length){
this._addHistory(_f);
if(!this._startTransitionEvent){
this.app.emit("app-transition",{viewId:_5.getTarget(_f),opts:{params:_5.getParams(_f)||{}}});
}
}else{
if(_f==this._current){
}else{
if(_f===this._previous){
this._back(_f,this._historyStack[this._index]["detail"]);
}else{
if(_f===this._next){
this._forward(_f,this._historyStack[this._index]["detail"]);
}else{
var _10=-1;
for(var i=this._index;i>0;i--){
if(_f===this._historyStack[i]["hash"]){
_10=i;
break;
}
}
if(-1===_10){
for(var i=this._index;i<this._historyStack.length;i++){
if(_f===this._historyStack[i]["hash"]){
_10=i;
break;
}
}
}
if(0<_10<this._historyStack.length){
this._go(_10,(_10-this._index));
}else{
this.app.log("go error. index out of history stack.");
}
}
}
}
}
this._startTransitionEvent=false;
},_back:function(_11,_12){
this.app.log("back");
this._next=this._historyStack[this._index]["hash"];
this._index--;
if(this._index>0){
this._previous=this._historyStack[this._index-1]["hash"];
}else{
this._previous=null;
}
this._current=_11;
var _13=_5.getTarget(_11,this.app.defaultView);
_3.publish("/app/history/back",{"viewId":_13,"detail":_12});
this.app.emit("app-transition",{viewId:_13,opts:_1.mixin({reverse:true},_12,{"params":_5.getParams(_11)})});
},_forward:function(_14,_15){
this.app.log("forward");
this._previous=this._historyStack[this._index]["hash"];
this._index++;
if(this._index<this._historyStack.length-1){
this._next=this._historyStack[this._index+1]["hash"];
}else{
this._next=null;
}
this._current=_14;
var _16=_5.getTarget(_14,this.app.defaultView);
_3.publish("/app/history/forward",{"viewId":_16,"detail":_15});
this.app.emit("app-transition",{viewId:_16,opts:_1.mixin({reverse:false},_15,{"params":_5.getParams(_14)})});
},_go:function(_17,_18){
if(_17<0||(_17>window.history.length-1)){
throw Error("Application history.go steps out of management, index: "+_17+" length: "+window.history.length);
}
this._index=_17;
this._current=this._historyStack[_17]["hash"];
this._previous=this._historyStack[_17-1]?this._historyStack[_17-1]["hash"]:null;
this._next=this._historyStack[_17+1]?this._historyStack[_17+1]["hash"]:null;
var _19=_5.getTarget(this._current,this.app.defaultView);
_3.publish("/app/history/go",{"viewId":_19,"step":_18,"detail":this._historyStack[_17]["detail"]});
this.app.emit("app-transition",{viewId:_19,opts:_1.mixin({reverse:(_18<=0)},this._historyStack[_17]["detail"],{"params":_5.getParams(this._current)})});
}});
});
