/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.base.semantic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import java.util.stream.Collectors;
import javax.swing.text.Document;
import jpt.sun.source.tree.CaseLabelTree;
import jpt.sun.source.tree.CaseTree;
import jpt.sun.source.tree.ClassTree;
import jpt.sun.source.tree.CompilationUnitTree;
import jpt.sun.source.tree.ExportsTree;
import jpt.sun.source.tree.ExpressionStatementTree;
import jpt.sun.source.tree.ExpressionTree;
import jpt.sun.source.tree.IdentifierTree;
import jpt.sun.source.tree.LiteralTree;
import jpt.sun.source.tree.MemberReferenceTree;
import jpt.sun.source.tree.MemberSelectTree;
import jpt.sun.source.tree.MethodInvocationTree;
import jpt.sun.source.tree.MethodTree;
import jpt.sun.source.tree.ModuleTree;
import jpt.sun.source.tree.NewClassTree;
import jpt.sun.source.tree.OpensTree;
import jpt.sun.source.tree.ParameterizedTypeTree;
import jpt.sun.source.tree.PatternCaseLabelTree;
import jpt.sun.source.tree.ProvidesTree;
import jpt.sun.source.tree.RequiresTree;
import jpt.sun.source.tree.Tree;
import jpt.sun.source.tree.UsesTree;
import jpt.sun.source.tree.VariableTree;
import jpt.sun.source.util.SourcePositions;
import jpt.sun.source.util.TreePath;
import jpt30.lang.model.element.Element;
import jpt30.lang.model.element.ElementKind;
import jpt30.lang.model.element.ExecutableElement;
import jpt30.lang.model.element.Modifier;
import jpt30.lang.model.type.TypeKind;
import jpt30.lang.model.type.TypeMirror;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaParserResultTask;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.TypeUtilities;
import org.netbeans.api.java.source.support.CancellableTreePathScanner;
import org.netbeans.api.lexer.PartType;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenUtilities;
import org.netbeans.modules.java.editor.base.imports.UnusedImports;
import org.netbeans.modules.java.editor.base.semantic.ColoringAttributes;
import org.netbeans.modules.java.editor.base.semantic.TokenList;
import org.netbeans.modules.java.editor.base.semantic.UnusedDetector;
import org.netbeans.modules.java.editor.base.semantic.Utilities;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.modules.parsing.spi.TaskIndexingMode;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbPreferences;
import org.openide.util.Pair;

public abstract class SemanticHighlighterBase
extends JavaParserResultTask<Parser.Result> {
    public static final String JAVA_INLINE_HINT_PARAMETER_NAME = "javaInlineHintParameterName";
    public static final String JAVA_INLINE_HINT_CHAINED_TYPES = "javaInlineHintChainedTypes";
    public static final String JAVA_INLINE_HINT_VAR_TYPE = "javaInlineHintVarType";
    private final AtomicBoolean cancel = new AtomicBoolean();
    private static final Set<ElementKind> LOCAL_VARIABLES = EnumSet.of(ElementKind.LOCAL_VARIABLE, ElementKind.RESOURCE_VARIABLE, ElementKind.EXCEPTION_PARAMETER, ElementKind.BINDING_VARIABLE);

    protected SemanticHighlighterBase() {
        super(JavaSource.Phase.RESOLVED, TaskIndexingMode.ALLOWED_DURING_SCAN);
    }

    @Override
    public void run(Parser.Result result, SchedulerEvent event) {
        CompilationInfo info = CompilationInfo.get(result);
        if (info == null) {
            return;
        }
        this.cancel.set(false);
        Document doc = result.getSnapshot().getSource().getDocument(false);
        if (!SemanticHighlighterBase.verifyDocument(doc)) {
            return;
        }
        this.process(info, doc);
    }

    private static boolean verifyDocument(Document doc) {
        if (doc == null) {
            Logger.getLogger(SemanticHighlighterBase.class.getName()).log(Level.FINE, "SemanticHighlighter: Cannot get document!");
            return false;
        }
        boolean[] tokenSequenceNull = new boolean[1];
        doc.render(() -> {
            tokenSequenceNull[0] = TokenHierarchy.get(doc).tokenSequence() == null;
        });
        return !tokenSequenceNull[0];
    }

    @Override
    public void cancel() {
        this.cancel.set(true);
    }

    @Override
    public int getPriority() {
        return 100;
    }

    @Override
    public Class<? extends Scheduler> getSchedulerClass() {
        return Scheduler.EDITOR_SENSITIVE_TASK_SCHEDULER;
    }

    protected abstract boolean process(CompilationInfo var1, Document var2);

    protected boolean process(CompilationInfo info, Document doc, ErrorDescriptionSetter setter) {
        return this.process(info, doc, Settings.getDefault(), setter);
    }

    protected boolean process(CompilationInfo info, Document doc, Settings settings, ErrorDescriptionSetter setter) {
        List<Pair<int[], ColoringAttributes.Coloring>> extraColoring;
        DetectorVisitor v = new DetectorVisitor(info, doc, settings, this.cancel);
        IdentityHashMap<Token, ColoringAttributes.Coloring> newColoring = new IdentityHashMap<Token, ColoringAttributes.Coloring>();
        CompilationUnitTree cu = info.getCompilationUnit();
        v.scan((Tree)cu, null);
        if (this.cancel.get()) {
            return true;
        }
        boolean computeUnusedImports = "text/x-java".equals(FileUtil.getMIMEType(info.getFileObject()));
        List<Pair<int[], ColoringAttributes.Coloring>> list = extraColoring = computeUnusedImports ? new ArrayList<Pair<int[], ColoringAttributes.Coloring>>(v.extraColoring) : v.extraColoring;
        if (computeUnusedImports) {
            Collection<TreePath> unusedImports = UnusedImports.process(info, this.cancel);
            if (unusedImports == null) {
                return true;
            }
            ColoringAttributes.Coloring unused = SemanticHighlighterBase.collection2Coloring(Arrays.asList(ColoringAttributes.UNUSED));
            for (TreePath tree : unusedImports) {
                if (this.cancel.get()) {
                    return true;
                }
                extraColoring.add(Pair.of(new int[]{(int)info.getTrees().getSourcePositions().getStartPosition(cu, tree.getLeaf()), (int)info.getTrees().getSourcePositions().getEndPosition(cu, tree.getLeaf())}, unused));
            }
        }
        Map<Element, List<UnusedDetector.UnusedDescription>> element2Unused = UnusedDetector.findUnused(info, () -> this.cancel.get()).stream().collect(Collectors.groupingBy(ud -> ud.unusedElement()));
        for (Map.Entry entry : v.type2Uses.entrySet()) {
            if (this.cancel.get()) {
                return true;
            }
            Element decl = (Element)entry.getKey();
            List uses = (List)entry.getValue();
            for (Use u : uses) {
                if (u.spec == null) continue;
                if (u.declaration && element2Unused.containsKey(decl)) {
                    u.spec.add(ColoringAttributes.UNUSED);
                }
                ColoringAttributes.Coloring c = SemanticHighlighterBase.collection2Coloring(u.spec);
                List<Token> tl = v.tree2Tokens.get(u.tree.getLeaf());
                if (tl == null) continue;
                for (Token t : tl) {
                    newColoring.put(t, c);
                }
            }
        }
        ColoringAttributes.Coloring kwc = SemanticHighlighterBase.collection2Coloring(EnumSet.of(ColoringAttributes.KEYWORD));
        for (Token kw : v.contextKeywords) {
            newColoring.put(kw, kwc);
        }
        if (this.cancel.get()) {
            return true;
        }
        if (computeUnusedImports) {
            HashMap<int[], String> hashMap = new HashMap<int[], String>();
            v.preText.forEach((pos, text) -> preTextWithSpans.put(new int[]{pos, pos + 1}, (String)text));
            setter.setHighlights(doc, extraColoring, hashMap);
        }
        setter.setColorings(doc, newColoring);
        return false;
    }

    private static ColoringAttributes.Coloring collection2Coloring(Collection<ColoringAttributes> attr) {
        ColoringAttributes.Coloring c = ColoringAttributes.empty();
        for (ColoringAttributes a : attr) {
            c = ColoringAttributes.add(c, a);
        }
        return c;
    }

    private static boolean isLocalVariableClosure(Element el) {
        return el.getKind() == ElementKind.PARAMETER || LOCAL_VARIABLES.contains((Object)el.getKind());
    }

    public record Settings(boolean javaInlineHintParameterName, boolean javaInlineHintChainedTypes, boolean javaInlineHintVarType) {
        private static final Map<String, Boolean> DEFAULT_VALUES = Map.of("javaInlineHintParameterName", true, "javaInlineHintChainedTypes", false, "javaInlineHintVarType", false);

        public static Settings getDefault() {
            Preferences preferences = NbPreferences.root().node("/org/netbeans/modules/java/editor/InlineHints/default");
            return new Settings(preferences.getBoolean(SemanticHighlighterBase.JAVA_INLINE_HINT_PARAMETER_NAME, DEFAULT_VALUES.get(SemanticHighlighterBase.JAVA_INLINE_HINT_PARAMETER_NAME)), preferences.getBoolean(SemanticHighlighterBase.JAVA_INLINE_HINT_CHAINED_TYPES, DEFAULT_VALUES.get(SemanticHighlighterBase.JAVA_INLINE_HINT_CHAINED_TYPES)), preferences.getBoolean(SemanticHighlighterBase.JAVA_INLINE_HINT_VAR_TYPE, DEFAULT_VALUES.get(SemanticHighlighterBase.JAVA_INLINE_HINT_VAR_TYPE)));
        }
    }

    public static interface ErrorDescriptionSetter {
        public void setHighlights(Document var1, Collection<Pair<int[], ColoringAttributes.Coloring>> var2, Map<int[], String> var3);

        public void setColorings(Document var1, Map<Token, ColoringAttributes.Coloring> var2);
    }

    private static class DetectorVisitor
    extends CancellableTreePathScanner<Void, Void> {
        private final CompilationInfo info;
        private final Settings settings;
        private Map<Element, List<Use>> type2Uses;
        private Map<Tree, List<Token>> tree2Tokens;
        private List<Token> contextKeywords;
        private List<Pair<int[], ColoringAttributes.Coloring>> extraColoring;
        private Map<Integer, String> preText;
        private final TokenList tl;
        private long memberSelectBypass = -1L;
        private final SourcePositions sourcePositions;
        private ExecutableElement recursionDetector;
        private static final Set<Tree.Kind> LITERALS = EnumSet.of(Tree.Kind.BOOLEAN_LITERAL, new Tree.Kind[]{Tree.Kind.CHAR_LITERAL, Tree.Kind.DOUBLE_LITERAL, Tree.Kind.FLOAT_LITERAL, Tree.Kind.INT_LITERAL, Tree.Kind.LONG_LITERAL, Tree.Kind.STRING_LITERAL});
        private static final ColoringAttributes.Coloring UNINDENTED_TEXT_BLOCK = ColoringAttributes.add(ColoringAttributes.empty(), ColoringAttributes.UNINDENTED_TEXT_BLOCK);

        private DetectorVisitor(CompilationInfo info, Document doc, Settings settings, AtomicBoolean cancel) {
            super(cancel);
            this.info = info;
            this.settings = settings;
            this.type2Uses = new HashMap<Element, List<Use>>();
            this.tree2Tokens = new IdentityHashMap<Tree, List<Token>>();
            this.contextKeywords = new ArrayList<Token>();
            this.extraColoring = new ArrayList<Pair<int[], ColoringAttributes.Coloring>>();
            this.preText = new HashMap<Integer, String>();
            this.tl = new TokenList(info, doc, cancel);
            this.sourcePositions = info.getTrees().getSourcePositions();
        }

        private void firstIdentifier(String name) {
            this.firstIdentifier(this.getCurrentPath(), name);
        }

        private void firstIdentifier(TreePath path, String name) {
            this.tl.firstIdentifier(path, name, this.tree2Tokens);
        }

        private Token firstIdentifierToken(String ... names) {
            for (String name : names) {
                Token t = this.tl.firstIdentifier(this.getCurrentPath(), name);
                if (t == null) continue;
                return t;
            }
            return null;
        }

        @Override
        public Void visitMemberSelect(MemberSelectTree tree, Void p) {
            if (this.info.getTreeUtilities().isSynthetic(this.getCurrentPath())) {
                return null;
            }
            long memberSelectBypassLoc = this.memberSelectBypass;
            this.memberSelectBypass = -1L;
            Element el = this.info.getTrees().getElement(this.getCurrentPath());
            if (el != null && el.getKind() == ElementKind.MODULE) {
                this.handlePossibleIdentifier(this.getCurrentPath(), false);
                this.tl.moduleNameHere(tree, this.tree2Tokens);
                return null;
            }
            super.visitMemberSelect(tree, p);
            this.tl.moveToEnd(tree.getExpression());
            if (memberSelectBypassLoc != -1L) {
                this.tl.moveToOffset(memberSelectBypassLoc);
            }
            this.handlePossibleIdentifier(this.getCurrentPath(), false);
            this.firstIdentifier(tree.getIdentifier().toString());
            this.addParameterInlineHint(tree);
            return null;
        }

        private void addModifiers(Element decl, Collection<ColoringAttributes> c) {
            if (decl.getModifiers().contains((Object)Modifier.STATIC)) {
                c.add(ColoringAttributes.STATIC);
            }
            if (decl.getModifiers().contains((Object)Modifier.ABSTRACT) && !decl.getKind().isInterface()) {
                c.add(ColoringAttributes.ABSTRACT);
            }
            boolean accessModifier = false;
            if (decl.getModifiers().contains((Object)Modifier.PUBLIC)) {
                c.add(ColoringAttributes.PUBLIC);
                accessModifier = true;
            }
            if (decl.getModifiers().contains((Object)Modifier.PROTECTED)) {
                c.add(ColoringAttributes.PROTECTED);
                accessModifier = true;
            }
            if (decl.getModifiers().contains((Object)Modifier.PRIVATE)) {
                c.add(ColoringAttributes.PRIVATE);
                accessModifier = true;
            }
            if (!accessModifier && !SemanticHighlighterBase.isLocalVariableClosure(decl)) {
                c.add(ColoringAttributes.PACKAGE_PRIVATE);
            }
            if (this.info.getElements().isDeprecated(decl)) {
                c.add(ColoringAttributes.DEPRECATED);
            }
        }

        private Collection<ColoringAttributes> getMethodColoring(ExecutableElement mdecl) {
            ArrayList<ColoringAttributes> c = new ArrayList<ColoringAttributes>();
            this.addModifiers(mdecl, c);
            if (mdecl.getKind() == ElementKind.CONSTRUCTOR) {
                c.add(ColoringAttributes.CONSTRUCTOR);
            } else {
                c.add(ColoringAttributes.METHOD);
            }
            return c;
        }

        private Collection<ColoringAttributes> getVariableColoring(Element decl) {
            ArrayList<ColoringAttributes> c = new ArrayList<ColoringAttributes>();
            this.addModifiers(decl, c);
            if (decl.getKind().isField() || decl.getKind() == ElementKind.RECORD_COMPONENT) {
                if (decl.getKind().isField()) {
                    c.add(ColoringAttributes.FIELD);
                } else {
                    c.add(ColoringAttributes.RECORD_COMPONENT);
                }
                return c;
            }
            if (LOCAL_VARIABLES.contains((Object)decl.getKind())) {
                c.add(ColoringAttributes.LOCAL_VARIABLE);
                return c;
            }
            if (decl.getKind() == ElementKind.PARAMETER) {
                c.add(ColoringAttributes.PARAMETER);
                return c;
            }
            assert (false);
            return null;
        }

        private void handlePossibleIdentifier(TreePath expr, boolean declaration) {
            this.handlePossibleIdentifier(expr, declaration, null);
        }

        private void handlePossibleIdentifier(TreePath expr, boolean declaration, Element decl) {
            if (Utilities.isKeyword(expr.getLeaf())) {
                return;
            }
            if (expr.getLeaf().getKind() == Tree.Kind.PRIMITIVE_TYPE) {
                return;
            }
            if (LITERALS.contains((Object)expr.getLeaf().getKind())) {
                return;
            }
            decl = decl == null ? Utilities.toRecordComponent(this.info.getTrees().getElement(expr)) : decl;
            ElementKind declKind = decl != null ? decl.getKind() : null;
            boolean isDeclType = decl != null && (declKind.isClass() || declKind.isInterface());
            TreePath currentPath = this.getCurrentPath();
            TreePath parent = currentPath.getParentPath();
            if (isDeclType && parent.getLeaf().getKind() == Tree.Kind.NEW_CLASS) {
                decl = this.info.getTrees().getElement(parent);
            }
            if (isDeclType && parent.getLeaf().getKind() == Tree.Kind.PARAMETERIZED_TYPE && ((ParameterizedTypeTree)parent.getLeaf()).getType() == currentPath.getLeaf() && parent.getParentPath().getLeaf().getKind() == Tree.Kind.NEW_CLASS) {
                decl = this.info.getTrees().getElement(parent.getParentPath());
            }
            if (decl == null) {
                return;
            }
            isDeclType = decl.getKind().isClass() || decl.getKind().isInterface();
            Collection<ColoringAttributes> c = null;
            if (decl.getKind().isField() || SemanticHighlighterBase.isLocalVariableClosure(decl) || decl.getKind() == ElementKind.RECORD_COMPONENT) {
                c = this.getVariableColoring(decl);
            }
            if (decl instanceof ExecutableElement) {
                ExecutableElement exec = (ExecutableElement)decl;
                c = this.getMethodColoring(exec);
            }
            if (decl.getKind() == ElementKind.MODULE) {
                c = new ArrayList<ColoringAttributes>();
                c.add(ColoringAttributes.MODULE);
            }
            if (isDeclType) {
                c = new ArrayList<ColoringAttributes>();
                this.addModifiers(decl, c);
                switch (decl.getKind()) {
                    case CLASS: {
                        c.add(ColoringAttributes.CLASS);
                        break;
                    }
                    case INTERFACE: {
                        c.add(ColoringAttributes.INTERFACE);
                        break;
                    }
                    case ANNOTATION_TYPE: {
                        c.add(ColoringAttributes.ANNOTATION_TYPE);
                        break;
                    }
                    case ENUM: {
                        c.add(ColoringAttributes.ENUM);
                        break;
                    }
                    case RECORD: {
                        c.add(ColoringAttributes.RECORD);
                    }
                }
            }
            if (declaration) {
                if (c == null) {
                    c = new ArrayList<ColoringAttributes>();
                }
                c.add(ColoringAttributes.DECLARATION);
            }
            if (c != null) {
                if (decl.getKind() == ElementKind.CONSTRUCTOR && !declaration && this.info.getElements().isDeprecated(decl.getEnclosingElement())) {
                    c.add(ColoringAttributes.DEPRECATED);
                }
                this.addUse(decl, declaration, expr, c);
            }
        }

        private void addUse(Element decl, boolean declaration, TreePath t, Collection<ColoringAttributes> c) {
            this.type2Uses.computeIfAbsent(decl, k -> new ArrayList()).add(new Use(declaration, t, c));
        }

        @Override
        public Void visitCompilationUnit(CompilationUnitTree tree, Void p) {
            this.tl.moveBefore(tree.getImports());
            this.scan(tree.getImports(), p);
            this.tl.moveBefore(tree.getPackageAnnotations());
            this.scan(tree.getPackageAnnotations(), p);
            this.tl.moveToEnd(tree.getImports());
            this.scan(tree.getTypeDecls(), p);
            return null;
        }

        @Override
        public Void visitModule(ModuleTree tree, Void p) {
            Element e;
            Token t;
            this.tl.moveToOffset(this.sourcePositions.getStartPosition(this.info.getCompilationUnit(), tree));
            this.scan(tree.getAnnotations(), p);
            this.tl.moveToEnd(tree.getAnnotations());
            if (tree.getModuleType() == ModuleTree.ModuleKind.OPEN) {
                t = this.firstIdentifierToken("open");
                if (t != null) {
                    this.contextKeywords.add(t);
                }
                this.tl.moveNext();
            }
            if ((t = this.firstIdentifierToken("module")) != null) {
                this.contextKeywords.add(t);
            }
            if ((e = this.info.getTrees().getElement(this.getCurrentPath())) != null && e.getKind() == ElementKind.MODULE) {
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), tree.getName()), true, e);
                this.tl.moduleNameHere(tree.getName(), this.tree2Tokens);
            }
            this.scan(tree.getDirectives(), p);
            return null;
        }

        @Override
        public Void visitExports(ExportsTree tree, Void p) {
            this.tl.moveToOffset(this.sourcePositions.getStartPosition(this.info.getCompilationUnit(), tree));
            Token t = this.firstIdentifierToken("exports");
            if (t != null) {
                this.contextKeywords.add(t);
            }
            this.scan((Tree)tree.getPackageName(), p);
            this.tl.moveToOffset(this.sourcePositions.getEndPosition(this.info.getCompilationUnit(), tree.getPackageName()));
            t = this.firstIdentifierToken("to");
            if (t != null) {
                this.contextKeywords.add(t);
            }
            return (Void)this.scan(tree.getModuleNames(), p);
        }

        @Override
        public Void visitOpens(OpensTree tree, Void p) {
            this.tl.moveToOffset(this.sourcePositions.getStartPosition(this.info.getCompilationUnit(), tree));
            Token t = this.firstIdentifierToken("opens");
            if (t != null) {
                this.contextKeywords.add(t);
            }
            this.scan((Tree)tree.getPackageName(), p);
            this.tl.moveToOffset(this.sourcePositions.getEndPosition(this.info.getCompilationUnit(), tree.getPackageName()));
            t = this.firstIdentifierToken("to");
            if (t != null) {
                this.contextKeywords.add(t);
            }
            return (Void)this.scan(tree.getModuleNames(), p);
        }

        @Override
        public Void visitProvides(ProvidesTree tree, Void p) {
            this.tl.moveToOffset(this.sourcePositions.getStartPosition(this.info.getCompilationUnit(), tree));
            Token t = this.firstIdentifierToken("provides");
            if (t != null) {
                this.contextKeywords.add(t);
            }
            this.scan((Tree)tree.getServiceName(), p);
            this.tl.moveToOffset(this.sourcePositions.getEndPosition(this.info.getCompilationUnit(), tree.getServiceName()));
            t = this.firstIdentifierToken("with");
            if (t != null) {
                this.contextKeywords.add(t);
            }
            return (Void)this.scan(tree.getImplementationNames(), p);
        }

        @Override
        public Void visitRequires(RequiresTree tree, Void p) {
            this.tl.moveToOffset(this.sourcePositions.getStartPosition(this.info.getCompilationUnit(), tree));
            Token t = this.firstIdentifierToken("requires");
            if (t != null) {
                this.contextKeywords.add(t);
                this.tl.moveNext();
                if (tree.isStatic() && tree.isTransitive()) {
                    t = this.firstIdentifierToken("static", "transitive");
                    if (t != null) {
                        this.contextKeywords.add(t);
                    }
                    this.tl.moveNext();
                    t = this.firstIdentifierToken("static", "transitive");
                    if (t != null) {
                        this.contextKeywords.add(t);
                    }
                } else if (tree.isStatic()) {
                    t = this.firstIdentifierToken("static");
                    if (t != null) {
                        this.contextKeywords.add(t);
                    }
                } else if (tree.isTransitive() && (t = this.firstIdentifierToken("transitive")) != null) {
                    this.contextKeywords.add(t);
                }
            }
            return (Void)super.visitRequires(tree, p);
        }

        @Override
        public Void visitCase(CaseTree node, Void p) {
            int restartIndex = this.tl.index();
            this.tl.moveToOffset(this.sourcePositions.getStartPosition(this.info.getCompilationUnit(), node));
            List<? extends CaseLabelTree> labels = node.getLabels();
            for (CaseLabelTree caseLabelTree : labels) {
                if (caseLabelTree.getKind() != Tree.Kind.PATTERN_CASE_LABEL) continue;
                PatternCaseLabelTree patternLabel = (PatternCaseLabelTree)caseLabelTree;
                this.tl.moveToOffset(this.sourcePositions.getEndPosition(this.info.getCompilationUnit(), patternLabel.getPattern()));
                this.tl.moveNext();
                if (this.tl.currentToken() == null || !TokenUtilities.equals(this.tl.currentToken().text(), "when")) continue;
                this.contextKeywords.add(this.tl.currentToken());
            }
            this.tl.resetToIndex(restartIndex);
            return (Void)super.visitCase(node, p);
        }

        @Override
        public Void visitUses(UsesTree tree, Void p) {
            this.tl.moveToOffset(this.sourcePositions.getStartPosition(this.info.getCompilationUnit(), tree));
            Token t = this.firstIdentifierToken("uses");
            if (t != null) {
                this.contextKeywords.add(t);
            }
            return (Void)super.visitUses(tree, p);
        }

        @Override
        public Void visitMethodInvocation(MethodInvocationTree tree, Void p) {
            List<? extends Tree> ta;
            String ident;
            int startTokenIndex = this.tl.index();
            ExpressionTree possibleIdent = tree.getMethodSelect();
            if (possibleIdent.getKind() == Tree.Kind.IDENTIFIER && ("super".equals(ident = ((IdentifierTree)possibleIdent).getName().toString()) || "this".equals(ident))) {
                Element resolved = this.info.getTrees().getElement(this.getCurrentPath());
                this.addUse(resolved, false, null, null);
            }
            long afterTypeArguments = (ta = tree.getTypeArguments()).isEmpty() ? -1L : this.info.getTrees().getSourcePositions().getEndPosition(this.info.getCompilationUnit(), ta.get(ta.size() - 1));
            switch (tree.getMethodSelect().getKind()) {
                case IDENTIFIER: 
                case MEMBER_SELECT: {
                    this.memberSelectBypass = afterTypeArguments;
                    this.scan((Tree)tree.getMethodSelect(), p);
                    this.memberSelectBypass = -1L;
                    break;
                }
                default: {
                    this.scan((Tree)tree.getMethodSelect(), p);
                }
            }
            this.tl.moveBefore(tree.getTypeArguments());
            this.scan(tree.getTypeArguments(), null);
            this.scan(tree.getArguments(), p);
            this.addParameterInlineHint(tree);
            Tree parent = this.getCurrentPath().getParentPath().getLeaf();
            Tree parentParent = this.getCurrentPath().getParentPath().getParentPath().getLeaf();
            if (parent.getKind() != Tree.Kind.MEMBER_SELECT || parentParent.getKind() != Tree.Kind.METHOD_INVOCATION || ((MemberSelectTree)parent).getExpression() != tree) {
                int afterInvocation = this.tl.index();
                this.tl.resetToIndex(startTokenIndex);
                this.addChainedTypes(this.getCurrentPath());
                this.tl.resetToIndex(afterInvocation);
            }
            return null;
        }

        private void addChainedTypes(TreePath current) {
            if (!this.settings.javaInlineHintChainedTypes) {
                return;
            }
            ArrayList<TreePath> chain = new ArrayList<TreePath>();
            block3: while (true) {
                chain.add(current);
                switch (current.getLeaf().getKind()) {
                    case METHOD_INVOCATION: {
                        MethodInvocationTree mit = (MethodInvocationTree)current.getLeaf();
                        if (mit.getMethodSelect().getKind() != Tree.Kind.MEMBER_SELECT) break block3;
                        current = new TreePath(new TreePath(current, mit.getMethodSelect()), ((MemberSelectTree)mit.getMethodSelect()).getExpression());
                        continue block3;
                    }
                }
                break;
            }
            Collections.reverse(chain);
            ArrayList<Pair<String, Integer>> typeToPosition = new ArrayList<Pair<String, Integer>>();
            ArrayList<Pair<String, Integer>> forcedTypeToPosition = new ArrayList<Pair<String, Integer>>();
            for (TreePath treePath : chain) {
                int pos;
                long end = this.info.getTrees().getSourcePositions().getEndPosition(treePath.getCompilationUnit(), treePath.getLeaf());
                this.tl.moveToOffset(end);
                Token t = this.tl.currentToken();
                if (t != null && (t.id() == JavaTokenId.COMMA || t.id() == JavaTokenId.SEMICOLON)) {
                    this.tl.moveNext();
                    t = this.tl.currentToken();
                } else if (t != null && t.id() == JavaTokenId.RPAREN) {
                    while (t != null && t.id() == JavaTokenId.RPAREN) {
                        this.tl.moveNext();
                        t = this.tl.currentToken();
                    }
                    if (t != null && (t.id() == JavaTokenId.COMMA || t.id() == JavaTokenId.SEMICOLON)) {
                        this.tl.moveNext();
                        t = this.tl.currentToken();
                    }
                }
                if (t == null || t.id() != JavaTokenId.WHITESPACE || (pos = t.text().toString().indexOf("\n")) == -1) continue;
                TypeMirror type = this.info.getTrees().getTypeMirror(treePath);
                String typeName = type.getKind().isPrimitive() || type.getKind() == TypeKind.DECLARED ? this.info.getTypeUtilities().getTypeName(type, new TypeUtilities.TypeNameOptions[0]).toString() : "";
                int preTextPos = this.tl.offset() + pos;
                if (typeToPosition.isEmpty() || !typeName.equals(((Pair)typeToPosition.get(typeToPosition.size() - 1)).first()) || this.preText.containsKey(preTextPos)) {
                    typeToPosition.add(Pair.of(typeName, preTextPos));
                }
                if (!this.preText.containsKey(preTextPos)) continue;
                forcedTypeToPosition.add(Pair.of(typeName, preTextPos));
            }
            if (typeToPosition.size() >= 2) {
                for (Pair pair : typeToPosition) {
                    this.preText.compute((Integer)pair.second(), (p, n) -> (n == null ? " " : ";") + " " + (String)typeAndPosition.first());
                }
            } else {
                for (Pair pair : forcedTypeToPosition) {
                    this.preText.compute((Integer)pair.second(), (p, n) -> (String)(n == null ? " " : n + ";") + " " + (String)typeAndPosition.first());
                }
            }
        }

        @Override
        public Void visitExpressionStatement(ExpressionStatementTree node, Void p) {
            return (Void)super.visitExpressionStatement(node, p);
        }

        @Override
        public Void visitIdentifier(IdentifierTree tree, Void p) {
            if (this.info.getTreeUtilities().isSynthetic(this.getCurrentPath())) {
                return null;
            }
            this.tl.moveToOffset(this.sourcePositions.getStartPosition(this.info.getCompilationUnit(), tree));
            if (this.memberSelectBypass != -1L) {
                this.tl.moveToOffset(this.memberSelectBypass);
                this.memberSelectBypass = -1L;
            }
            this.tl.identifierHere(tree, this.tree2Tokens);
            this.handlePossibleIdentifier(this.getCurrentPath(), false);
            this.addParameterInlineHint(tree);
            super.visitIdentifier(tree, null);
            return null;
        }

        @Override
        public Void visitMethod(MethodTree tree, Void p) {
            String name;
            if (this.info.getTreeUtilities().isSynthetic(this.getCurrentPath())) {
                return (Void)super.visitMethod(tree, p);
            }
            this.tl.moveToOffset(this.sourcePositions.getStartPosition(this.info.getCompilationUnit(), tree));
            this.handlePossibleIdentifier(this.getCurrentPath(), true);
            Element el = this.info.getTrees().getElement(this.getCurrentPath());
            this.scan((Tree)tree.getModifiers(), null);
            this.tl.moveToEnd(tree.getModifiers());
            this.scan(tree.getTypeParameters(), null);
            this.tl.moveToEnd(tree.getTypeParameters());
            this.scan(tree.getReturnType(), p);
            this.tl.moveToEnd(tree.getReturnType());
            if (tree.getReturnType() != null) {
                name = tree.getName().toString();
            } else {
                TreePath tp;
                for (tp = this.getCurrentPath(); tp != null && !TreeUtilities.CLASS_TREE_KINDS.contains((Object)tp.getLeaf().getKind()); tp = tp.getParentPath()) {
                }
                name = tp != null && TreeUtilities.CLASS_TREE_KINDS.contains((Object)tp.getLeaf().getKind()) ? ((ClassTree)tp.getLeaf()).getSimpleName().toString() : null;
            }
            if (name != null) {
                this.firstIdentifier(name);
            }
            this.scan(tree.getParameters(), null);
            this.scan(tree.getThrows(), null);
            this.scan(tree.getDefaultValue(), null);
            this.recursionDetector = el != null && el.getKind() == ElementKind.METHOD ? (ExecutableElement)el : null;
            this.scan((Tree)tree.getBody(), null);
            this.recursionDetector = null;
            return null;
        }

        @Override
        public Void visitVariable(VariableTree tree, Void p) {
            if (this.info.getTreeUtilities().isSynthetic(this.getCurrentPath())) {
                return null;
            }
            this.tl.moveToOffset(this.sourcePositions.getStartPosition(this.info.getCompilationUnit(), tree));
            this.handlePossibleIdentifier(this.getCurrentPath(), true);
            this.scan((Tree)tree.getModifiers(), null);
            this.tl.moveToEnd(tree.getModifiers());
            this.scan(tree.getType(), null);
            int[] span = this.info.getTreeUtilities().findNameSpan(tree);
            if (span != null) {
                this.tl.moveToOffset(span[0]);
            } else {
                this.tl.moveToEnd(tree.getType());
            }
            this.firstIdentifier(tree.getName().toString());
            this.tl.moveNext();
            if (this.info.getTreeUtilities().isVarType(this.getCurrentPath()) && this.settings.javaInlineHintVarType) {
                int afterName = this.tl.offset();
                TypeMirror type = this.info.getTrees().getTypeMirror(new TreePath(this.getCurrentPath(), tree.getType()));
                this.preText.put(afterName, " : " + this.info.getTypeUtilities().getTypeName(type, new TypeUtilities.TypeNameOptions[0]));
            }
            this.scan((Tree)tree.getInitializer(), p);
            return null;
        }

        @Override
        public Void visitNewClass(NewClassTree tree, Void p) {
            ExpressionTree ident = tree.getIdentifier();
            TreePath tp = ident.getKind() == Tree.Kind.PARAMETERIZED_TYPE ? new TreePath(new TreePath(this.getCurrentPath(), ident), ((ParameterizedTypeTree)((Object)ident)).getType()) : new TreePath(this.getCurrentPath(), ident);
            Element clazz = this.info.getTrees().getElement(tp);
            if (clazz != null) {
                this.addUse(clazz, false, null, null);
            }
            this.scan((Tree)tree.getEnclosingExpression(), null);
            this.scan((Tree)tree.getIdentifier(), null);
            this.scan(tree.getTypeArguments(), null);
            this.scan(tree.getArguments(), p);
            this.scan((Tree)tree.getClassBody(), null);
            return null;
        }

        @Override
        public Void visitClass(ClassTree tree, Void p) {
            this.tl.moveToOffset(this.sourcePositions.getStartPosition(this.info.getCompilationUnit(), tree));
            this.handlePossibleIdentifier(this.getCurrentPath(), true);
            this.scan((Tree)tree.getModifiers(), null);
            this.tl.moveToEnd(tree.getModifiers());
            boolean record = false;
            Token recordToken = this.tl.firstIdentifier(this.getCurrentPath(), "record");
            if (recordToken != null) {
                this.contextKeywords.add(recordToken);
                this.tl.moveNext();
                record = true;
            }
            this.firstIdentifier(tree.getSimpleName().toString());
            this.scan(tree.getTypeParameters(), null);
            if (record) {
                this.scan(tree.getMembers().stream().filter(m -> this.isRecordComponent((Tree)m)).toList(), null);
            }
            this.scan(tree.getExtendsClause(), null);
            this.scan(tree.getImplementsClause(), null);
            try {
                List<? extends Tree> permitList = tree.getPermitsClause();
                if (permitList != null && !permitList.isEmpty()) {
                    this.tl.moveNext();
                    Token t = this.firstIdentifierToken("permits");
                    if (this.tl != null) {
                        this.contextKeywords.add(t);
                        this.scan(permitList, null);
                    }
                }
            }
            catch (NullPointerException permitList) {
                // empty catch block
            }
            ExecutableElement prevRecursionDetector = this.recursionDetector;
            this.recursionDetector = null;
            if (record) {
                this.scan(tree.getMembers().stream().filter(m -> !this.isRecordComponent((Tree)m)).toList(), null);
            } else {
                this.scan(tree.getMembers(), null);
            }
            this.recursionDetector = prevRecursionDetector;
            return null;
        }

        private boolean isRecordComponent(Tree member) {
            Element el = this.info.getTrees().getElement(new TreePath(this.getCurrentPath(), member));
            return el != null && Utilities.toRecordComponent(el).getKind() == ElementKind.RECORD_COMPONENT;
        }

        @Override
        public Void visitMemberReference(MemberReferenceTree node, Void p) {
            this.scan((Tree)node.getQualifierExpression(), p);
            this.tl.moveToEnd(node.getQualifierExpression());
            this.scan(node.getTypeArguments(), null);
            this.tl.moveToEnd(node.getTypeArguments());
            this.handlePossibleIdentifier(this.getCurrentPath(), false);
            this.firstIdentifier(node.getName().toString());
            return null;
        }

        @Override
        public Void visitLiteral(LiteralTree node, Void p) {
            int startPos = (int)this.info.getTrees().getSourcePositions().getStartPosition(this.info.getCompilationUnit(), node);
            this.tl.moveToOffset(startPos);
            Token t = this.tl.currentToken();
            if (t != null && t.id() == JavaTokenId.MULTILINE_STRING_LITERAL && t.partType() == PartType.COMPLETE) {
                String tokenText = t.text().toString();
                String[] lines = tokenText.split("\n");
                int indent = Arrays.stream(lines, 1, lines.length).filter(l -> !l.isBlank()).mapToInt(this::leadingIndent).min().orElse(0);
                int pos = startPos + lines[0].length() + 1;
                for (int i = 1; i < lines.length; ++i) {
                    String line = lines[i];
                    if (i == lines.length - 1) {
                        line = line.substring(0, line.length() - 3);
                    }
                    String strippendLine = line.replaceAll("[\t ]+$", "");
                    int indentedStart = pos + indent;
                    int indentedEnd = pos + strippendLine.length();
                    if (indentedEnd > indentedStart) {
                        this.extraColoring.add(Pair.of(new int[]{indentedStart, indentedEnd}, UNINDENTED_TEXT_BLOCK));
                    }
                    pos += line.length() + 1;
                }
            }
            this.addParameterInlineHint(node);
            return (Void)super.visitLiteral(node, p);
        }

        @Override
        public Void scan(Tree tree, Void p) {
            if (tree != null && tree.getKind() == Tree.Kind.YIELD) {
                this.tl.moveToOffset(this.sourcePositions.getStartPosition(this.info.getCompilationUnit(), tree));
                Token t = this.firstIdentifierToken("yield");
                if (t != null) {
                    this.contextKeywords.add(t);
                }
            } else if (tree != null && tree.getKind() == Tree.Kind.MODIFIERS) {
                this.visitModifier(tree);
            }
            return (Void)super.scan(tree, p);
        }

        private void visitModifier(Tree tree) {
            this.tl.moveToOffset(this.sourcePositions.getStartPosition(this.info.getCompilationUnit(), tree));
            Token t = null;
            if (tree.toString().contains("non-sealed")) {
                Token firstIdentifier = this.tl.firstIdentifier(this.getCurrentPath(), "non");
                if (firstIdentifier != null) {
                    this.contextKeywords.add(firstIdentifier);
                }
                this.tl.moveNext();
                this.tl.moveNext();
                if (TokenUtilities.textEquals(this.tl.currentToken().text(), "sealed")) {
                    this.contextKeywords.add(this.tl.currentToken());
                }
            } else if (tree.toString().contains("sealed") && (t = this.firstIdentifierToken("sealed")) != null) {
                this.contextKeywords.add(t);
            }
        }

        private int leadingIndent(String line) {
            int indent = 0;
            for (int i = 0; i < line.length() && Character.isWhitespace(line.charAt(i)); ++i) {
                ++indent;
            }
            return indent;
        }

        private void addParameterInlineHint(Tree tree) {
            if (!this.settings.javaInlineHintParameterName) {
                return;
            }
            TreePath pp = this.getCurrentPath().getParentPath();
            Tree leaf = pp.getLeaf();
            if (leaf != null && (leaf.getKind() == Tree.Kind.METHOD_INVOCATION || leaf.getKind() == Tree.Kind.NEW_CLASS)) {
                Element invoked;
                int pos = -1;
                if (leaf.getKind() == Tree.Kind.METHOD_INVOCATION) {
                    pos = ((MethodInvocationTree)MethodInvocationTree.class.cast(leaf)).getArguments().indexOf(tree);
                } else if (leaf.getKind() == Tree.Kind.NEW_CLASS) {
                    pos = ((NewClassTree)NewClassTree.class.cast(leaf)).getArguments().indexOf(tree);
                }
                if (pos != -1 && (invoked = this.info.getTrees().getElement(pp)) != null && (invoked.getKind() == ElementKind.METHOD || invoked.getKind() == ElementKind.CONSTRUCTOR)) {
                    long start = this.sourcePositions.getStartPosition(this.info.getCompilationUnit(), tree);
                    ExecutableElement invokedMethod = (ExecutableElement)invoked;
                    if ((pos = Math.min(pos, invokedMethod.getParameters().size() - 1)) != -1) {
                        boolean shouldBeAdded = true;
                        if (tree.getKind() == Tree.Kind.IDENTIFIER && invokedMethod.getParameters().get(pos).getSimpleName().equals(((IdentifierTree)IdentifierTree.class.cast(tree)).getName())) {
                            shouldBeAdded = false;
                        }
                        if (shouldBeAdded) {
                            this.preText.put((int)start, invokedMethod.getParameters().get(pos).getSimpleName() + ":");
                        }
                    }
                }
            }
        }
    }

    private record Use(boolean declaration, TreePath tree, Collection<ColoringAttributes> spec) {
        @Override
        public String toString() {
            return "Use: " + this.spec;
        }
    }
}

