/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.bean.openapi3;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.juneau.annotation.Beanp;
import org.apache.juneau.bean.openapi3.Encoding;
import org.apache.juneau.bean.openapi3.Example;
import org.apache.juneau.bean.openapi3.OpenApiElement;
import org.apache.juneau.bean.openapi3.SchemaInfo;
import org.apache.juneau.commons.collections.MultiSet;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.internal.ConverterUtils;

public class MediaType
extends OpenApiElement {
    private SchemaInfo schema;
    private Object example;
    private Map<String, Example> examples = CollectionUtils.map();
    private Map<String, Encoding> encoding = CollectionUtils.map();

    public MediaType() {
    }

    public MediaType(MediaType copyFrom) {
        super(copyFrom);
        this.schema = copyFrom.schema;
        this.example = copyFrom.example;
        if (Utils.nn(copyFrom.examples)) {
            this.examples.putAll(CollectionUtils.copyOf(copyFrom.examples, Example::copy));
        }
        if (Utils.nn(copyFrom.encoding)) {
            this.encoding.putAll(CollectionUtils.copyOf(copyFrom.encoding, Encoding::copy));
        }
    }

    public MediaType addEncoding(String key, Encoding value) {
        AssertionUtils.assertArgNotNull((String)"key", (Object)key);
        AssertionUtils.assertArgNotNull((String)"value", (Object)value);
        this.encoding.put(key, value);
        return this;
    }

    public MediaType addExample(String name, Example example) {
        AssertionUtils.assertArgNotNull((String)"name", (Object)name);
        AssertionUtils.assertArgNotNull((String)"example", (Object)example);
        this.examples.put(name, example);
        return this;
    }

    public MediaType copy() {
        return new MediaType(this);
    }

    @Override
    public <T> T get(String property, Class<T> type) {
        AssertionUtils.assertArgNotNull((String)"property", (Object)property);
        return (T)(switch (property) {
            case "encoding" -> ConverterUtils.toType(this.getEncoding(), type);
            case "examples" -> ConverterUtils.toType(this.getExamples(), type);
            case "schema" -> ConverterUtils.toType((Object)this.getSchema(), type);
            case "x-example" -> ConverterUtils.toType((Object)this.getExample(), type);
            default -> super.get(property, type);
        });
    }

    public Map<String, Encoding> getEncoding() {
        return Utils.nullIfEmpty(this.encoding);
    }

    @Beanp(value="x-example")
    public Object getExample() {
        return this.example;
    }

    public Map<String, Example> getExamples() {
        return Utils.nullIfEmpty(this.examples);
    }

    public SchemaInfo getSchema() {
        return this.schema;
    }

    @Override
    public Set<String> keySet() {
        Set s = CollectionUtils.setb(String.class).addIf(Utils.ne(this.encoding), (Object)"encoding").addIf(Utils.ne(this.examples), (Object)"examples").addIf(Utils.nn((Object)this.schema), (Object)"schema").addIf(Utils.nn((Object)this.example), (Object)"x-example").build();
        return new MultiSet(new Collection[]{s, super.keySet()});
    }

    @Override
    public MediaType set(String property, Object value) {
        AssertionUtils.assertArgNotNull((String)"property", (Object)property);
        return switch (property) {
            case "encoding" -> this.setEncoding(ConverterUtils.toMapBuilder((Object)value, String.class, Encoding.class).sparse().build());
            case "examples" -> this.setExamples(ConverterUtils.toMapBuilder((Object)value, String.class, Example.class).sparse().build());
            case "schema" -> this.setSchema((SchemaInfo)ConverterUtils.toType((Object)value, SchemaInfo.class));
            case "x-example" -> this.setExample(value);
            default -> {
                super.set(property, value);
                yield this;
            }
        };
    }

    public MediaType setEncoding(Map<String, Encoding> value) {
        this.encoding.clear();
        if (Utils.nn(value)) {
            this.encoding.putAll(value);
        }
        return this;
    }

    @Beanp(value="x-example")
    public MediaType setExample(Object value) {
        this.example = value;
        return this;
    }

    public MediaType setExamples(Map<String, Example> value) {
        this.examples.clear();
        if (Utils.nn(value)) {
            this.examples.putAll(value);
        }
        return this;
    }

    public MediaType setSchema(SchemaInfo value) {
        this.schema = value;
        return this;
    }

    @Override
    public MediaType strict(Object value) {
        super.strict(value);
        return this;
    }

    @Override
    protected MediaType strict() {
        super.strict();
        return this;
    }
}

