/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.exec.http;

import java.io.FileNotFoundException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.atlas.web.HttpException;
import org.apache.jena.http.HttpEnv;
import org.apache.jena.http.HttpLib;
import org.apache.jena.http.Push;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RDFWriterRegistry;
import org.apache.jena.riot.system.StreamRDFWriter;
import org.apache.jena.shared.NotFoundException;

public abstract class StoreProtocol<X extends StoreProtocol<X>> {
    protected String serviceEndpoint = null;
    protected RDFFormat rdfFormat = null;
    protected HttpClient httpClient = null;
    protected Map<String, String> httpHeaders = new HashMap<String, String>();

    protected StoreProtocol() {
    }

    protected abstract X thisBuilder();

    public X endpoint(String serviceURL) {
        this.serviceEndpoint = Objects.requireNonNull(serviceURL);
        return this.thisBuilder();
    }

    protected String endpoint() {
        return this.serviceEndpoint;
    }

    public X httpClient(HttpClient httpClient) {
        Objects.requireNonNull(httpClient, "HttpClient");
        this.httpClient = httpClient;
        return this.thisBuilder();
    }

    public X httpHeader(String headerName, String headerValue) {
        Objects.requireNonNull(headerName);
        Objects.requireNonNull(headerValue);
        if (this.httpHeaders == null) {
            this.httpHeaders = new HashMap<String, String>();
        }
        this.httpHeaders.put(headerName, headerValue);
        return this.thisBuilder();
    }

    protected String httpHeader(String header) {
        Objects.requireNonNull(header);
        if (this.httpHeaders == null) {
            return null;
        }
        return this.httpHeaders.get(header);
    }

    public X acceptHeader(String acceptHeader) {
        this.httpHeader("Accept", acceptHeader);
        return this.thisBuilder();
    }

    protected String acceptHeader() {
        return this.httpHeader("Accept");
    }

    public X accept(Lang lang) {
        String acceptHeader = lang != null ? lang.getContentType().getContentTypeStr() : null;
        this.httpHeader("Accept", acceptHeader);
        return this.thisBuilder();
    }

    public X contentTypeHeader(String contentType) {
        this.httpHeader("Content-Type", contentType);
        return this.thisBuilder();
    }

    protected String contentType() {
        return this.httpHeader("Content-Type");
    }

    public X contentType(RDFFormat rdfFormat) {
        this.rdfFormat = rdfFormat;
        String contentType = rdfFormat.getLang().getContentType().getContentTypeStr();
        this.httpHeader("Content-Type", contentType);
        return this.thisBuilder();
    }

    protected RDFFormat rdfFormat() {
        return this.rdfFormat;
    }

    public X copySetup(StoreProtocol<?> other) {
        this.clearSetup();
        other.httpHeaders(this::httpHeader);
        if (other.endpoint() != null) {
            this.endpoint(other.endpoint());
        }
        if (other.httpClient() != null) {
            this.httpClient(other.httpClient());
        }
        if (other.rdfFormat() != null) {
            this.rdfFormat(other.rdfFormat());
        }
        return this.thisBuilder();
    }

    private void clearSetup() {
        this.serviceEndpoint = null;
        this.rdfFormat = null;
        this.httpClient = null;
        this.httpHeaders = new HashMap<String, String>();
    }

    protected HttpClient requestHttpClient(String serviceURL, String requestURL) {
        if (this.httpClient != null) {
            return this.httpClient;
        }
        return HttpEnv.getHttpClient(serviceURL, this.httpClient);
    }

    protected static RuntimeException exception(String msg) {
        return new HttpException(msg);
    }

    protected final String service() {
        return this.serviceEndpoint;
    }

    protected final HttpClient httpClient() {
        return this.httpClient;
    }

    protected final void httpHeaders(BiConsumer<String, String> action) {
        this.httpHeaders.forEach(action);
    }

    protected void ensureAcceptHeader(String dftAcceptheader) {
        String requestAccept = StoreProtocol.header(this.acceptHeader(), "text/turtle,application/n-triples;q=0.9,application/rdf+xml;q=0.7,application/trig,application/n-quads;q=0.9,application/ld+json;q=0.8,*/*;q=0.5");
        this.acceptHeader(requestAccept);
    }

    private static String header(String choice, String dftString) {
        return choice != null ? choice : dftString;
    }

    protected RDFFormat rdfFormat(RDFFormat dftFormat) {
        if (this.rdfFormat != null) {
            return this.rdfFormat;
        }
        if (this.contentType() == null) {
            return dftFormat;
        }
        Lang lang = RDFLanguages.contentTypeToLang(this.contentType());
        RDFFormat streamFormat = StreamRDFWriter.defaultSerialization(null);
        if (streamFormat != null) {
            return streamFormat;
        }
        return RDFWriterRegistry.defaultSerialization(lang);
    }

    protected String contentTypeFromFilename(String filename) {
        ContentType ct = RDFLanguages.guessContentType(filename);
        if (ct != null) {
            return ct.getContentTypeStr();
        }
        String ctx = this.contentType();
        if (ctx != null) {
            return ctx;
        }
        return null;
    }

    protected static void pushFile(HttpClient httpClient, String endpoint, String file, String fileContentType, Map<String, String> httpHeaders, Push style) {
        try {
            Path path = Path.of(file, new String[0]);
            if (fileContentType != null) {
                httpHeaders.put("Content-Type", fileContentType);
            }
            HttpRequest.BodyPublisher body = HttpRequest.BodyPublishers.ofFile(path);
            HttpLib.httpPushData(httpClient, style, endpoint, HttpLib.setHeaders(httpHeaders), body);
        }
        catch (FileNotFoundException ex) {
            throw new NotFoundException(file);
        }
    }
}

