/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontapi.assemblers;

import java.util.ArrayList;
import java.util.List;
import org.apache.jena.assembler.Assembler;
import org.apache.jena.assembler.Mode;
import org.apache.jena.assembler.assemblers.AssemblerBase;
import org.apache.jena.assembler.exceptions.AssemblerException;
import org.apache.jena.assembler.exceptions.CannotHaveRulesException;
import org.apache.jena.assembler.exceptions.NotExpectedTypeException;
import org.apache.jena.assembler.exceptions.UnknownReasonerException;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphMemFactory;
import org.apache.jena.graph.GraphUtil;
import org.apache.jena.ontapi.assemblers.OA;
import org.apache.jena.ontapi.assemblers.OntRuleSetAssembler;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.reasoner.Reasoner;
import org.apache.jena.reasoner.ReasonerFactory;
import org.apache.jena.reasoner.ReasonerRegistry;
import org.apache.jena.reasoner.rulesys.GenericRuleReasoner;
import org.apache.jena.reasoner.rulesys.GenericRuleReasonerFactory;
import org.apache.jena.reasoner.rulesys.Rule;

public class OntReasonerFactoryAssembler
extends AssemblerBase {
    public Object open(Assembler a, Resource root, Mode irrelevant) {
        this.checkType(root, OA.ReasonerFactory);
        return this.addSchema(root, a, this.addRules(root, a, OntReasonerFactoryAssembler.getReasonerFactory(root)));
    }

    private ReasonerFactory addSchema(Resource root, Assembler a, final ReasonerFactory rf) {
        if (!root.hasProperty(OA.schema)) {
            return rf;
        }
        final Graph schema = this.loadSchema(root, a);
        return new ReasonerFactory(){

            public Reasoner create(Resource configuration) {
                return rf.create(configuration).bindSchema(schema);
            }

            public Model getCapabilities() {
                return rf.getCapabilities();
            }

            public String getURI() {
                return rf.getURI();
            }
        };
    }

    private Graph loadSchema(Resource root, Assembler a) {
        Graph result = GraphMemFactory.createDefaultGraph();
        root.listProperties(OA.schema).forEach(statement -> this.loadSchema(result, a, OntReasonerFactoryAssembler.getResource((Statement)statement)));
        return result;
    }

    private void loadSchema(Graph result, Assembler a, Resource root) {
        Model m = a.openModel(root);
        Graph g = m.getGraph();
        g.getTransactionHandler().executeAlways(() -> GraphUtil.addInto((Graph)result, (Graph)m.getGraph()));
    }

    private ReasonerFactory addRules(Resource root, Assembler a, final ReasonerFactory r) {
        final List<Rule> rules = OntRuleSetAssembler.addRules(new ArrayList<Rule>(), a, root);
        if (rules.isEmpty()) {
            return r;
        }
        if (!(r instanceof GenericRuleReasonerFactory)) {
            throw new CannotHaveRulesException(root);
        }
        return new ReasonerFactory(){

            public Reasoner create(Resource configuration) {
                GenericRuleReasoner result = (GenericRuleReasoner)r.create(configuration);
                result.addRules(rules);
                return result;
            }

            public Model getCapabilities() {
                return r.getCapabilities();
            }

            public String getURI() {
                return r.getURI();
            }
        };
    }

    protected Reasoner getReasoner(Resource root) {
        return OntReasonerFactoryAssembler.getReasonerFactory(root).create(root);
    }

    protected static ReasonerFactory getReasonerFactory(Resource root) {
        Resource reasonerURL = OntReasonerFactoryAssembler.getUniqueResource((Resource)root, (Property)OA.reasonerURL);
        String className = OntReasonerFactoryAssembler.getOptionalClassName(root);
        return className != null ? OntReasonerFactoryAssembler.getReasonerFactoryByClassName(root, className) : (reasonerURL == null ? GenericRuleReasonerFactory.theInstance() : OntReasonerFactoryAssembler.getReasonerFactoryByURL(root, reasonerURL));
    }

    private static ReasonerFactory getReasonerFactoryByClassName(Resource root, String className) {
        Class c = OntReasonerFactoryAssembler.loadClass((Resource)root, (String)className);
        OntReasonerFactoryAssembler.mustBeReasonerFactory(root, c);
        ReasonerFactory theInstance = OntReasonerFactoryAssembler.resultFromStatic(c, "theInstance");
        return theInstance == null ? OntReasonerFactoryAssembler.createInstance(root, c) : theInstance;
    }

    private static ReasonerFactory createInstance(Resource root, Class<?> c) {
        try {
            return (ReasonerFactory)c.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new AssemblerException(root, "could not create instance of " + c.getName(), (Throwable)e);
        }
    }

    private static ReasonerFactory resultFromStatic(Class<?> c, String methodName) {
        try {
            return (ReasonerFactory)c.getMethod(methodName, null).invoke(null, (Object[])null);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static void mustBeReasonerFactory(Resource root, Class<?> c) {
        if (!ReasonerFactory.class.isAssignableFrom(c)) {
            throw new NotExpectedTypeException(root, ReasonerFactory.class, c);
        }
    }

    private static String getOptionalClassName(Resource root) {
        return OntReasonerFactoryAssembler.getOptionalClassName((Resource)root, (Property)OA.reasonerClass);
    }

    public static ReasonerFactory getReasonerFactoryByURL(Resource root, Resource reasonerURL) {
        String url = reasonerURL.getURI();
        ReasonerFactory factory = ReasonerRegistry.theRegistry().getFactory(url);
        if (factory == null) {
            throw new UnknownReasonerException(root, reasonerURL);
        }
        return factory;
    }
}

