/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.monitors;

import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class MonitorAttribute
implements Serializable {
    private static final long serialVersionUID = 7931725606171964572L;
    @NotNull
    private final Class<?> dataType;
    @NotNull
    private final Object[] values;
    @Nullable
    private final String description;
    @NotNull
    private final String displayName;
    @NotNull
    private final String name;

    public MonitorAttribute(@NotNull String name, @NotNull String displayName, @Nullable String description, @NotNull Boolean value) {
        this(name, displayName, description, Boolean.class, new Object[]{value});
        Validator.ensureNotNull(value);
    }

    public MonitorAttribute(@NotNull String name, @NotNull String displayName, @Nullable String description, @NotNull Date value) {
        this(name, displayName, description, Date.class, new Object[]{value});
        Validator.ensureNotNull(value);
    }

    public MonitorAttribute(@NotNull String name, @NotNull String displayName, @Nullable String description, @NotNull Date[] values) {
        this(name, displayName, description, Date.class, values);
    }

    public MonitorAttribute(@NotNull String name, @NotNull String displayName, @Nullable String description, @NotNull Double value) {
        this(name, displayName, description, Double.class, new Object[]{value});
        Validator.ensureNotNull(value);
    }

    public MonitorAttribute(@NotNull String name, @NotNull String displayName, @Nullable String description, @NotNull Double[] values) {
        this(name, displayName, description, Double.class, values);
    }

    public MonitorAttribute(@NotNull String name, @NotNull String displayName, @Nullable String description, @NotNull Integer value) {
        this(name, displayName, description, Integer.class, new Object[]{value});
        Validator.ensureNotNull(value);
    }

    public MonitorAttribute(@NotNull String name, @NotNull String displayName, @Nullable String description, @NotNull Integer[] values) {
        this(name, displayName, description, Integer.class, values);
    }

    public MonitorAttribute(@NotNull String name, @NotNull String displayName, @Nullable String description, @NotNull Long value) {
        this(name, displayName, description, Long.class, new Object[]{value});
        Validator.ensureNotNull(value);
    }

    public MonitorAttribute(@NotNull String name, @NotNull String displayName, @Nullable String description, @NotNull Long[] values) {
        this(name, displayName, description, Long.class, values);
    }

    public MonitorAttribute(@NotNull String name, @NotNull String displayName, @Nullable String description, @NotNull String value) {
        this(name, displayName, description, String.class, new Object[]{value});
        Validator.ensureNotNull(value);
    }

    public MonitorAttribute(@NotNull String name, @NotNull String displayName, @Nullable String description, @NotNull String[] values) {
        this(name, displayName, description, String.class, values);
    }

    private MonitorAttribute(@NotNull String name, @NotNull String displayName, @Nullable String description, @NotNull Class<?> dataType, @NotNull Object[] values) {
        Validator.ensureNotNull(name, displayName, dataType, values);
        Validator.ensureFalse(values.length == 0, "MonitorAttribute.values must not be empty.");
        this.name = name;
        this.displayName = displayName;
        this.description = description;
        this.dataType = dataType;
        this.values = values;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public String getDisplayName() {
        return this.displayName;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @NotNull
    public Class<?> getDataType() {
        return this.dataType;
    }

    public boolean hasMultipleValues() {
        return this.values.length > 1;
    }

    @NotNull
    public Object getValue() {
        return this.values[0];
    }

    @NotNull
    public List<Object> getValues() {
        return Collections.unmodifiableList(Arrays.asList(this.values));
    }

    @NotNull
    public Boolean getBooleanValue() throws ClassCastException {
        return (Boolean)this.values[0];
    }

    @NotNull
    public Date getDateValue() throws ClassCastException {
        return (Date)this.values[0];
    }

    @NotNull
    public List<Date> getDateValues() throws ClassCastException {
        return Collections.unmodifiableList(Arrays.asList((Date[])this.values));
    }

    @NotNull
    public Double getDoubleValue() throws ClassCastException {
        return (Double)this.values[0];
    }

    @NotNull
    public List<Double> getDoubleValues() throws ClassCastException {
        return Collections.unmodifiableList(Arrays.asList((Double[])this.values));
    }

    @NotNull
    public Integer getIntegerValue() throws ClassCastException {
        return (Integer)this.values[0];
    }

    @NotNull
    public List<Integer> getIntegerValues() throws ClassCastException {
        return Collections.unmodifiableList(Arrays.asList((Integer[])this.values));
    }

    @NotNull
    public Long getLongValue() throws ClassCastException {
        return (Long)this.values[0];
    }

    @NotNull
    public List<Long> getLongValues() throws ClassCastException {
        return Collections.unmodifiableList(Arrays.asList((Long[])this.values));
    }

    @NotNull
    public String getStringValue() throws ClassCastException {
        return (String)this.values[0];
    }

    @NotNull
    public List<String> getStringValues() throws ClassCastException {
        return Collections.unmodifiableList(Arrays.asList((String[])this.values));
    }

    @NotNull
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("MonitorAttribute(name='");
        buffer.append(this.name);
        buffer.append("', values={");
        for (int i = 0; i < this.values.length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append('\'');
            buffer.append(String.valueOf(this.values[i]));
            buffer.append('\'');
        }
        buffer.append("})");
    }
}

