/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.servererrors;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.DriverException;
import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.servererrors.QueryConsistencyException;
import edu.umd.cs.findbugs.annotations.NonNull;

public class CASWriteUnknownException
extends QueryConsistencyException {
    public CASWriteUnknownException(@NonNull Node coordinator, @NonNull ConsistencyLevel consistencyLevel, int received, int blockFor) {
        this(coordinator, String.format("CAS operation result is unknown - proposal was not accepted by a quorum. (%d / %d)", received, blockFor), consistencyLevel, received, blockFor, null, false);
    }

    private CASWriteUnknownException(@NonNull Node coordinator, @NonNull String message, @NonNull ConsistencyLevel consistencyLevel, int received, int blockFor, ExecutionInfo executionInfo, boolean writableStackTrace) {
        super(coordinator, message, consistencyLevel, received, blockFor, executionInfo, writableStackTrace);
    }

    @Override
    @NonNull
    public DriverException copy() {
        return new CASWriteUnknownException(this.getCoordinator(), this.getMessage(), this.getConsistencyLevel(), this.getReceived(), this.getBlockFor(), this.getExecutionInfo(), true);
    }
}

