/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.ToLongFunction;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.SizeInBytes;
import org.apache.ratis.util.TimeDuration;
import org.apache.ratis.util.Timestamp;
import org.apache.ratis.util.function.CheckedFunctionWithTimeout;
import org.apache.ratis.util.function.TriConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataQueue<E>
implements Iterable<E> {
    public static final Logger LOG = LoggerFactory.getLogger(DataQueue.class);
    private final Object name;
    private final long byteLimit;
    private final int elementLimit;
    private final ToLongFunction<E> getNumBytes;
    private final Queue<E> q;
    private long numBytes = 0L;

    public DataQueue(Object name, SizeInBytes byteLimit, int elementLimit, ToLongFunction<E> getNumBytes) {
        this.name = name != null ? name : this;
        this.byteLimit = byteLimit.getSize();
        this.elementLimit = elementLimit;
        this.getNumBytes = getNumBytes;
        this.q = new LinkedList();
    }

    public int getElementLimit() {
        return this.elementLimit;
    }

    public long getByteLimit() {
        return this.byteLimit;
    }

    public long getNumBytes() {
        return this.numBytes;
    }

    public int getNumElements() {
        return this.q.size();
    }

    public final boolean isEmpty() {
        return this.getNumElements() == 0;
    }

    public void clear() {
        this.q.clear();
        this.numBytes = 0L;
    }

    public boolean offer(E element) {
        Objects.requireNonNull(element, "element == null");
        if (this.elementLimit > 0 && this.q.size() >= this.elementLimit) {
            return false;
        }
        long elementNumBytes = this.getNumBytes.applyAsLong(element);
        Preconditions.assertTrue(elementNumBytes >= 0L, () -> this.name + ": elementNumBytes = " + elementNumBytes + " < 0");
        if (this.byteLimit > 0L) {
            Preconditions.assertTrue(elementNumBytes <= this.byteLimit, () -> this.name + ": elementNumBytes = " + elementNumBytes + " > byteLimit = " + this.byteLimit);
            if (this.numBytes > this.byteLimit - elementNumBytes) {
                return false;
            }
        }
        this.q.offer(element);
        this.numBytes += elementNumBytes;
        return true;
    }

    public <RESULT, THROWABLE extends Throwable> List<RESULT> pollList(long timeoutMs, CheckedFunctionWithTimeout<E, RESULT, THROWABLE> getResult, TriConsumer<E, TimeDuration, TimeoutException> timeoutHandler) throws THROWABLE {
        if (timeoutMs <= 0L || this.q.isEmpty()) {
            return Collections.emptyList();
        }
        Timestamp startTime = Timestamp.currentTime();
        TimeDuration limit = TimeDuration.valueOf(timeoutMs, TimeUnit.MILLISECONDS);
        ArrayList<RESULT> results = new ArrayList<RESULT>();
        Object peeked;
        while ((peeked = this.q.peek()) != null) {
            TimeDuration remaining = limit.subtract(startTime.elapsedTime());
            try {
                results.add(getResult.apply(peeked, remaining));
            }
            catch (TimeoutException e) {
                Optional.ofNullable(timeoutHandler).ifPresent(h -> h.accept(peeked, remaining, e));
                return results;
            }
            E polled = this.poll();
            Preconditions.assertTrue(polled == peeked);
        }
        return results;
    }

    public E poll() {
        E polled = this.q.poll();
        if (polled != null) {
            this.numBytes -= this.getNumBytes.applyAsLong(polled);
        }
        return polled;
    }

    public E peek() {
        return this.q.peek();
    }

    public boolean remove(E e) {
        boolean removed = this.q.remove(e);
        if (removed) {
            this.numBytes -= this.getNumBytes.applyAsLong(e);
        }
        return removed;
    }

    @Override
    public Iterator<E> iterator() {
        final Iterator i = this.q.iterator();
        return new Iterator<E>(){

            @Override
            public boolean hasNext() {
                return i.hasNext();
            }

            @Override
            public E next() {
                return i.next();
            }
        };
    }
}

