/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.grpc.Internal;
import io.grpc.LoadBalancer;
import io.grpc.LoadBalancerProvider;
import io.grpc.LoadBalancerRegistry;
import io.grpc.NameResolver;
import io.grpc.Status;
import io.grpc.internal.JsonUtil;
import io.grpc.xds.CdsLoadBalancer2;
import java.util.Map;

@Internal
public class CdsLoadBalancerProvider
extends LoadBalancerProvider {
    private final LoadBalancerRegistry loadBalancerRegistry;

    public boolean isAvailable() {
        return true;
    }

    public int getPriority() {
        return 5;
    }

    public String getPolicyName() {
        return "cds_experimental";
    }

    public CdsLoadBalancerProvider() {
        this.loadBalancerRegistry = null;
    }

    public CdsLoadBalancerProvider(LoadBalancerRegistry loadBalancerRegistry) {
        this.loadBalancerRegistry = loadBalancerRegistry;
    }

    public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
        LoadBalancerRegistry loadBalancerRegistry = this.loadBalancerRegistry;
        if (loadBalancerRegistry == null) {
            loadBalancerRegistry = LoadBalancerRegistry.getDefaultRegistry();
        }
        return new CdsLoadBalancer2(helper, loadBalancerRegistry);
    }

    public NameResolver.ConfigOrError parseLoadBalancingPolicyConfig(Map<String, ?> rawLoadBalancingPolicyConfig) {
        return CdsLoadBalancerProvider.parseLoadBalancingConfigPolicy(rawLoadBalancingPolicyConfig);
    }

    static NameResolver.ConfigOrError parseLoadBalancingConfigPolicy(Map<String, ?> rawLoadBalancingPolicyConfig) {
        try {
            String cluster = JsonUtil.getString(rawLoadBalancingPolicyConfig, (String)"cluster");
            Boolean isDynamic = JsonUtil.getBoolean(rawLoadBalancingPolicyConfig, (String)"is_dynamic");
            if (isDynamic == null) {
                isDynamic = Boolean.FALSE;
            }
            return NameResolver.ConfigOrError.fromConfig((Object)new CdsConfig(cluster, isDynamic));
        }
        catch (RuntimeException e) {
            return NameResolver.ConfigOrError.fromError((Status)Status.UNAVAILABLE.withCause((Throwable)e).withDescription("Failed to parse CDS LB config: " + rawLoadBalancingPolicyConfig));
        }
    }

    static final class CdsConfig {
        final String name;
        final boolean isDynamic;

        CdsConfig(String name) {
            this(name, false);
        }

        CdsConfig(String name, boolean isDynamic) {
            Preconditions.checkArgument((name != null && !name.isEmpty() ? 1 : 0) != 0, (Object)"name is null or empty");
            this.name = name;
            this.isDynamic = isDynamic;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("isDynamic", this.isDynamic).toString();
        }
    }
}

