/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basecrdt.store;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.protobuf.ByteString;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tags;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.schedulers.Schedulers;
import io.reactivex.rxjava3.subjects.PublishSubject;
import io.reactivex.rxjava3.subjects.Subject;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.bifromq.basecrdt.core.api.ICRDTOperation;
import org.apache.bifromq.basecrdt.core.api.ICausalCRDT;
import org.apache.bifromq.basecrdt.core.exception.CRDTNotFoundException;
import org.apache.bifromq.basecrdt.core.internal.CausalCRDTInflaterFactory;
import org.apache.bifromq.basecrdt.proto.Replica;
import org.apache.bifromq.basecrdt.store.AntiEntropyManager;
import org.apache.bifromq.basecrdt.store.CRDTStoreOptions;
import org.apache.bifromq.basecrdt.store.ICRDTStore;
import org.apache.bifromq.basecrdt.store.MessagePayloadUtil;
import org.apache.bifromq.basecrdt.store.PartialMesh;
import org.apache.bifromq.basecrdt.store.compressor.Compressor;
import org.apache.bifromq.basecrdt.store.proto.CRDTStoreMessage;
import org.apache.bifromq.basecrdt.store.proto.MessagePayload;
import org.apache.bifromq.basecrdt.util.Formatter;
import org.apache.bifromq.logger.MDCLogger;
import org.slf4j.Logger;

class CRDTStore
implements ICRDTStore {
    private final Logger log;
    private final String storeId;
    private final AtomicReference<State> state = new AtomicReference<State>(State.INIT);
    private final CRDTStoreOptions options;
    private final CausalCRDTInflaterFactory inflaterFactory;
    private final Subject<CRDTStoreMessage> storeMsgPublisher = PublishSubject.create().toSerialized();
    private final Map<String, AntiEntropyManager> antiEntroyMgrs = Maps.newConcurrentMap();
    private final Compressor compressor;
    private final CompositeDisposable disposable = new CompositeDisposable();
    private final ScheduledExecutorService storeExecutor;
    private final MetricManager metricManager;

    public CRDTStore(CRDTStoreOptions options) {
        this.options = options;
        this.storeId = options.id();
        this.log = MDCLogger.getLogger(CRDTStore.class, (String[])new String[]{"store", this.storeId});
        this.storeExecutor = options.storeExecutor();
        String[] tags = new String[]{"store.id", this.storeId};
        this.inflaterFactory = new CausalCRDTInflaterFactory(options.id(), options.inflationInterval(), options.orHistoryExpireTime(), options.maxCompactionTime(), this.storeExecutor, tags);
        this.compressor = Compressor.newInstance(options.compressAlgorithm());
        this.metricManager = new MetricManager(Tags.of((String[])tags));
    }

    @Override
    public String id() {
        return this.storeId;
    }

    @Override
    public <O extends ICRDTOperation, T extends ICausalCRDT<O>> T host(Replica replicaId, ByteString localAddr) {
        this.checkState();
        AntiEntropyManager antiEntropyMgr = this.antiEntroyMgrs.computeIfAbsent(replicaId.getUri(), k -> new AntiEntropyManager(this.storeId, localAddr, this.inflaterFactory.create(replicaId), this.storeExecutor, this.options.maxEventsInDelta(), new String[0]));
        antiEntropyMgr.neighborMessages().subscribe(t -> this.storeMsgPublisher.onNext((Object)CRDTStoreMessage.newBuilder().setUri(replicaId.getUri()).setSender(localAddr).setReceiver(t.neighborAddress()).setPayload(MessagePayloadUtil.compressToPayload(this.compressor, t.deltaMsg())).build()));
        return (T)antiEntropyMgr.crdt();
    }

    @Override
    public CompletableFuture<Void> stopHosting(Replica replicaId) {
        this.checkState();
        AntiEntropyManager antiEntropyMgr = this.antiEntroyMgrs.remove(replicaId.getUri());
        if (antiEntropyMgr == null) {
            return CompletableFuture.failedFuture(new CRDTNotFoundException());
        }
        return antiEntropyMgr.stop();
    }

    @Override
    public void join(Replica replicaId, Set<ByteString> memberAddrs) {
        this.checkState();
        AntiEntropyManager antiEntropyMgr = this.antiEntroyMgrs.get(replicaId.getUri());
        if (antiEntropyMgr == null) {
            throw new CRDTNotFoundException();
        }
        TreeSet<ByteString> sortedMembers = new TreeSet<ByteString>(ByteString.unsignedLexicographicalComparator());
        sortedMembers.add(antiEntropyMgr.localAddr());
        sortedMembers.addAll(memberAddrs);
        Set<ByteString> neighborAddrs = PartialMesh.neighbors(sortedMembers, antiEntropyMgr.localAddr());
        antiEntropyMgr.setNeighbors(neighborAddrs);
    }

    @Override
    public Observable<CRDTStoreMessage> storeMessages() {
        this.checkState();
        return this.storeMsgPublisher;
    }

    @Override
    public void start(Observable<CRDTStoreMessage> replicaMessages) {
        if (this.state.compareAndSet(State.INIT, State.STARTING)) {
            this.disposable.add(replicaMessages.subscribeOn(Schedulers.from((Executor)this.storeExecutor)).subscribe(msg -> {
                if (this.started()) {
                    this.handleStoreMessage((CRDTStoreMessage)msg);
                }
            }));
            this.state.set(State.STARTED);
            this.log.debug("Started CRDTStore[{}]", (Object)this.id());
        } else {
            this.log.warn("Start more than one time");
        }
    }

    @Override
    public void stop() {
        if (this.state.compareAndSet(State.STARTED, State.STOPPED)) {
            this.log.debug("Stop CRDTStore[{}]", (Object)this.id());
            this.antiEntroyMgrs.forEach((uri, aaMgr) -> aaMgr.stop());
            this.antiEntroyMgrs.clear();
            this.metricManager.close();
            this.disposable.dispose();
            this.state.set(State.STOPPED);
        }
    }

    private void handleStoreMessage(CRDTStoreMessage msg) {
        AntiEntropyManager antiEntropyMgr = this.antiEntroyMgrs.get(msg.getUri());
        if (antiEntropyMgr != null && antiEntropyMgr.localAddr().equals((Object)msg.getReceiver())) {
            MessagePayload payload = MessagePayloadUtil.decompress(this.compressor, msg);
            switch (payload.getMsgTypeCase()) {
                case DELTA: {
                    antiEntropyMgr.receive(payload.getDelta(), msg.getSender()).thenAccept(ack -> this.storeMsgPublisher.onNext((Object)CRDTStoreMessage.newBuilder().setUri(msg.getUri()).setSender(msg.getReceiver()).setReceiver(msg.getSender()).setPayload(MessagePayloadUtil.compressToPayload(this.compressor, ack)).build()));
                    break;
                }
                case ACK: {
                    antiEntropyMgr.receive(payload.getAck(), msg.getSender());
                    break;
                }
                default: {
                    this.log.warn("Unknown message type: {}", (Object)payload.getMsgTypeCase());
                    break;
                }
            }
        } else {
            this.log.debug("No anti-entropy manager of crdt[{}] bind to addr[{}], ignore the message from addr[{}]", new Object[]{msg.getUri(), Formatter.toPrintable(msg.getReceiver()), Formatter.toPrintable(msg.getSender())});
        }
    }

    private boolean started() {
        return this.state.get() == State.STARTED;
    }

    private void checkState() {
        Preconditions.checkState((boolean)this.started(), (Object)"Not started");
    }

    private static enum State {
        INIT,
        STARTING,
        STARTED,
        STOPPING,
        STOPPED;

    }

    private class MetricManager {
        final Gauge objectNumGauge;

        MetricManager(Tags tags) {
            this.objectNumGauge = Gauge.builder((String)"basecrdt.objectnum", (Object)CRDTStore.this, r -> r.antiEntroyMgrs.size()).tags((Iterable)tags).register((MeterRegistry)Metrics.globalRegistry);
        }

        void close() {
            Metrics.globalRegistry.removeByPreFilterId(this.objectNumGauge.getId());
        }
    }
}

