/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.communication.tcp.internal;

import java.util.UUID;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.NotNull;

public class ConnectionKey {
    private final UUID nodeId;
    private final int idx;
    private final long connCnt;
    private final boolean dummy;

    public ConnectionKey(@NotNull UUID nodeId, int idx) {
        this(nodeId, idx, -1L, false);
    }

    public ConnectionKey(@NotNull UUID nodeId, int idx, long connCnt) {
        this(nodeId, idx, connCnt, false);
    }

    public ConnectionKey(@NotNull UUID nodeId, int idx, long connCnt, boolean dummy) {
        this.nodeId = nodeId;
        this.idx = idx;
        this.connCnt = connCnt;
        this.dummy = dummy;
    }

    public long connectCount() {
        return this.connCnt;
    }

    public UUID nodeId() {
        return this.nodeId;
    }

    public int connectionIndex() {
        return this.idx;
    }

    public boolean dummy() {
        return this.dummy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectionKey key = (ConnectionKey)o;
        return this.idx == key.idx && this.nodeId.equals(key.nodeId);
    }

    public int hashCode() {
        int res = this.nodeId.hashCode();
        res = 31 * res + this.idx;
        return res;
    }

    public String toString() {
        return S.toString(ConnectionKey.class, this);
    }
}

