/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc.jdbc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcParameterMeta;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcProtocolContext;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcResult;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;

public class JdbcMetaParamsResult
extends JdbcResult {
    private List<JdbcParameterMeta> meta;

    JdbcMetaParamsResult() {
        super((byte)10);
    }

    JdbcMetaParamsResult(List<JdbcParameterMeta> meta) {
        super((byte)10);
        this.meta = meta;
    }

    @Override
    public void writeBinary(BinaryWriterExImpl writer, JdbcProtocolContext protoCtx) throws BinaryObjectException {
        super.writeBinary(writer, protoCtx);
        if (F.isEmpty(this.meta)) {
            writer.writeInt(0);
        } else {
            writer.writeInt(this.meta.size());
            for (JdbcParameterMeta m : this.meta) {
                m.writeBinary(writer, protoCtx);
            }
        }
    }

    @Override
    public void readBinary(BinaryReaderExImpl reader, JdbcProtocolContext protoCtx) throws BinaryObjectException {
        super.readBinary(reader, protoCtx);
        int size = reader.readInt();
        if (size == 0) {
            this.meta = Collections.emptyList();
        } else {
            this.meta = new ArrayList<JdbcParameterMeta>(size);
            for (int i = 0; i < size; ++i) {
                JdbcParameterMeta m = new JdbcParameterMeta();
                m.readBinary(reader, protoCtx);
                this.meta.add(m);
            }
        }
    }

    public List<JdbcParameterMeta> meta() {
        return this.meta;
    }

    @Override
    public String toString() {
        return S.toString(JdbcMetaParamsResult.class, this);
    }
}

