/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc.jdbc;

import java.io.IOException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteIllegalStateException;
import org.apache.ignite.internal.processors.bulkload.BulkLoadProcessor;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcBulkLoadBatchRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcCursor;
import org.apache.ignite.internal.processors.query.IgniteSQLException;

public class JdbcBulkLoadProcessor
extends JdbcCursor {
    private final BulkLoadProcessor processor;
    protected long nextBatchIdx;

    public JdbcBulkLoadProcessor(BulkLoadProcessor processor, long reqId) {
        super(reqId);
        this.processor = processor;
        this.nextBatchIdx = 0L;
    }

    public void processBatch(JdbcBulkLoadBatchRequest req) throws IgniteCheckedException {
        if (this.nextBatchIdx != req.batchIdx() && req.cmd() != 1) {
            throw new IgniteSQLException("Batch #" + (this.nextBatchIdx + 1L) + " is missing. Received #" + req.batchIdx() + " instead.");
        }
        ++this.nextBatchIdx;
        switch (req.cmd()) {
            case 2: {
                this.processor.processBatch(req.data(), true);
                break;
            }
            case 0: {
                this.processor.processBatch(req.data(), false);
                break;
            }
            case 1: {
                break;
            }
            default: {
                throw new IgniteIllegalStateException("Command was not recognized: " + req.cmd());
            }
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.processor.close();
            this.nextBatchIdx = -1L;
        }
        catch (Exception e) {
            throw new IOException("Unable to close processor: " + e.getMessage(), e);
        }
    }

    public void onFail(Exception reason) {
        this.processor.onError(reason);
    }

    public long updateCnt() {
        return this.processor.outputStreamer().updateCnt();
    }
}

