/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.systemview.utils;

import java.util.ArrayList;
import org.apache.ignite3.internal.catalog.commands.ColumnParams;
import org.apache.ignite3.internal.catalog.commands.CreateSystemViewCommand;
import org.apache.ignite3.internal.catalog.descriptors.CatalogSystemViewDescriptor;
import org.apache.ignite3.internal.schema.BinaryTupleSchema;
import org.apache.ignite3.internal.systemview.api.ClusterSystemView;
import org.apache.ignite3.internal.systemview.api.NodeSystemView;
import org.apache.ignite3.internal.systemview.api.SystemView;
import org.apache.ignite3.internal.systemview.api.SystemViewColumn;
import org.apache.ignite3.internal.type.DecimalNativeType;
import org.apache.ignite3.internal.type.NativeType;
import org.apache.ignite3.internal.type.NativeTypes;
import org.apache.ignite3.internal.type.TemporalNativeType;
import org.apache.ignite3.internal.type.VarlenNativeType;
import org.apache.ignite3.sql.ColumnType;

public class SystemViewUtils {
    private static final int STRING_FIELD_LENGTH = 65536;

    public static BinaryTupleSchema tupleSchemaForView(SystemView<?> view) {
        int viewColumn = view.columns().size();
        boolean nodeView = view instanceof NodeSystemView;
        BinaryTupleSchema.Element[] elements = new BinaryTupleSchema.Element[viewColumn + (nodeView ? 1 : 0)];
        int offset = 0;
        if (nodeView) {
            elements[offset++] = new BinaryTupleSchema.Element(NativeTypes.stringOf(65536), false);
        }
        for (int i = 0; i < viewColumn; ++i) {
            NativeType type = view.columns().get(i).type();
            elements[i + offset] = new BinaryTupleSchema.Element(type, true);
        }
        return BinaryTupleSchema.create(elements);
    }

    public static CreateSystemViewCommand toSystemViewCreateCommand(SystemView<?> view) {
        CatalogSystemViewDescriptor.SystemViewType viewType;
        ArrayList<ColumnParams> columnParams = new ArrayList<ColumnParams>(view.columns().size());
        if (view instanceof NodeSystemView) {
            columnParams.add(ColumnParams.builder().name(((NodeSystemView)view).nodeNameColumnAlias()).type(ColumnType.STRING).length(65536).nullable(false).build());
            viewType = CatalogSystemViewDescriptor.SystemViewType.NODE;
        } else {
            assert (view instanceof ClusterSystemView) : view.getClass().getCanonicalName();
            viewType = CatalogSystemViewDescriptor.SystemViewType.CLUSTER;
        }
        for (SystemViewColumn<?, ?> col : view.columns()) {
            columnParams.add(SystemViewUtils.systemViewColumnToColumnParams(col));
        }
        return CreateSystemViewCommand.builder().name(view.name()).columns(columnParams).type(viewType).build();
    }

    private static ColumnParams systemViewColumnToColumnParams(SystemViewColumn<?, ?> column) {
        NativeType type = column.type();
        ColumnType typeSpec = type.spec();
        ColumnParams.Builder builder = ColumnParams.builder().name(column.name()).type(typeSpec).nullable(true);
        switch (typeSpec) {
            case INT8: 
            case INT16: 
            case INT32: 
            case INT64: 
            case FLOAT: 
            case DOUBLE: 
            case DATE: 
            case UUID: 
            case BOOLEAN: {
                break;
            }
            case DECIMAL: {
                assert (type instanceof DecimalNativeType) : type.getClass().getCanonicalName();
                builder.precision(((DecimalNativeType)type).precision());
                builder.scale(((DecimalNativeType)type).scale());
                break;
            }
            case STRING: 
            case BYTE_ARRAY: {
                assert (type instanceof VarlenNativeType) : type.getClass().getCanonicalName();
                builder.length(((VarlenNativeType)type).length());
                break;
            }
            case TIME: 
            case DATETIME: 
            case TIMESTAMP: {
                assert (type instanceof TemporalNativeType) : type.getClass().getCanonicalName();
                builder.precision(((TemporalNativeType)type).precision());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported native type: " + typeSpec);
            }
        }
        return builder.build();
    }
}

