/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.raft;

public class IndexWithTerm
implements Comparable<IndexWithTerm> {
    private final long index;
    private final long term;

    public IndexWithTerm(long index, long term) {
        this.index = index;
        this.term = term;
    }

    public long index() {
        return this.index;
    }

    public long term() {
        return this.term;
    }

    @Override
    public int compareTo(IndexWithTerm that) {
        int byTerm = Long.compare(this.term, that.term);
        if (byTerm != 0) {
            return byTerm;
        }
        return Long.compare(this.index, that.index);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexWithTerm that = (IndexWithTerm)o;
        if (this.index != that.index) {
            return false;
        }
        return this.term == that.term;
    }

    public int hashCode() {
        int result = (int)(this.index ^ this.index >>> 32);
        result = 31 * result + (int)(this.term ^ this.term >>> 32);
        return result;
    }

    public String toString() {
        return this.index + ":" + this.term;
    }
}

