/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.metastorage.timebag;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.ignite3.internal.metastorage.timebag.IgniteTicker;

final class IgniteStopwatch {
    private final IgniteTicker ticker;
    private boolean isRunning;
    private long elapsedNanos;
    private long startTick;

    static IgniteStopwatch createUnstarted() {
        return new IgniteStopwatch();
    }

    private static IgniteStopwatch createUnstarted(IgniteTicker ticker) {
        return new IgniteStopwatch(ticker);
    }

    static IgniteStopwatch createStarted() {
        return new IgniteStopwatch().start();
    }

    static IgniteStopwatch createStarted(IgniteTicker ticker) {
        return new IgniteStopwatch(ticker).start();
    }

    IgniteStopwatch() {
        this.ticker = IgniteTicker.systemTicker();
    }

    IgniteStopwatch(IgniteTicker ticker) {
        this.ticker = ticker;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public IgniteStopwatch start() {
        assert (!this.isRunning) : "This stopwatch is already running.";
        this.isRunning = true;
        this.startTick = this.ticker.read();
        return this;
    }

    public IgniteStopwatch stop() {
        long tick = this.ticker.read();
        assert (this.isRunning) : "This stopwatch is already stopped.";
        this.isRunning = false;
        this.elapsedNanos += tick - this.startTick;
        return this;
    }

    public IgniteStopwatch reset() {
        this.elapsedNanos = 0L;
        this.isRunning = false;
        return this;
    }

    private long elapsedNanos() {
        return this.isRunning ? this.ticker.read() - this.startTick + this.elapsedNanos : this.elapsedNanos;
    }

    long elapsed(TimeUnit desiredUnit) {
        return desiredUnit.convert(this.elapsedNanos(), TimeUnit.NANOSECONDS);
    }

    private Duration elapsed() {
        return Duration.ofNanos(this.elapsedNanos());
    }
}

