/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cli.call.node.metric;

import jakarta.inject.Singleton;
import org.apache.ignite3.internal.cli.call.metric.MetricSourceEnableCallInput;
import org.apache.ignite3.internal.cli.core.call.Call;
import org.apache.ignite3.internal.cli.core.call.CallOutput;
import org.apache.ignite3.internal.cli.core.call.DefaultCallOutput;
import org.apache.ignite3.internal.cli.core.exception.IgniteCliApiException;
import org.apache.ignite3.internal.cli.core.rest.ApiClientFactory;
import org.apache.ignite3.rest.client.api.NodeMetricApi;
import org.apache.ignite3.rest.client.invoker.ApiException;

@Singleton
public class NodeMetricSourceEnableCall
implements Call<MetricSourceEnableCallInput, String> {
    private final ApiClientFactory clientFactory;

    public NodeMetricSourceEnableCall(ApiClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    @Override
    public CallOutput<String> execute(MetricSourceEnableCallInput input) {
        NodeMetricApi api = this.createApiClient(input);
        try {
            if (input.getEnable()) {
                api.enableNodeMetric(input.getSrcName());
            } else {
                api.disableNodeMetric(input.getSrcName());
            }
            String message = input.getEnable() ? "enabled" : "disabled";
            return DefaultCallOutput.success("Metric source was " + message + " successfully");
        }
        catch (IllegalArgumentException | ApiException e) {
            return DefaultCallOutput.failure(new IgniteCliApiException(e, input.getEndpointUrl()));
        }
    }

    private NodeMetricApi createApiClient(MetricSourceEnableCallInput input) {
        return new NodeMetricApi(this.clientFactory.getClient(input.getEndpointUrl()));
    }
}

