/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.client;

import org.apache.ignite3.internal.client.SslConfigurationImpl;
import org.jetbrains.annotations.Nullable;

public interface SslConfiguration {
    public boolean enabled();

    @Nullable
    public Iterable<String> ciphers();

    @Nullable
    public String keyStorePath();

    @Nullable
    public String keyStorePassword();

    @Nullable
    public String trustStorePath();

    @Nullable
    public String trustStorePassword();

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private boolean enabled = false;
        @Nullable
        private Iterable<String> ciphers;
        @Nullable
        private String keyStorePath;
        @Nullable
        private String keyStorePassword;
        @Nullable
        private String trustStorePath;
        @Nullable
        private String trustStorePassword;

        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder ciphers(@Nullable Iterable<String> ciphers) {
            this.ciphers = ciphers;
            return this;
        }

        public Builder keyStorePath(@Nullable String keyStorePath) {
            this.keyStorePath = keyStorePath;
            return this;
        }

        public Builder keyStorePassword(@Nullable String keyStorePassword) {
            this.keyStorePassword = keyStorePassword;
            return this;
        }

        public Builder trustStorePath(@Nullable String trustStorePath) {
            this.trustStorePath = trustStorePath;
            return this;
        }

        public Builder trustStorePassword(@Nullable String trustStorePassword) {
            this.trustStorePassword = trustStorePassword;
            return this;
        }

        public SslConfiguration build() {
            return new SslConfigurationImpl(this.enabled, this.ciphers, this.keyStorePath, this.keyStorePassword, this.trustStorePath, this.trustStorePassword);
        }
    }
}

