/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.server.reactive;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import org.apache.catalina.connector.CoyoteInputStream;
import org.apache.catalina.connector.CoyoteOutputStream;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.RequestFacade;
import org.apache.catalina.connector.ResponseFacade;
import org.apache.coyote.Response;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.AbstractListenerReadPublisher;
import org.springframework.http.server.reactive.HttpHandler;
import org.springframework.http.server.reactive.ServletHttpHandlerAdapter;
import org.springframework.http.server.reactive.ServletServerHttpRequest;
import org.springframework.http.server.reactive.ServletServerHttpResponse;
import org.springframework.http.server.reactive.TomcatHeadersAdapter;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ReflectionUtils;

public class TomcatHttpHandlerAdapter
extends ServletHttpHandlerAdapter {
    public TomcatHttpHandlerAdapter(HttpHandler httpHandler) {
        super(httpHandler);
    }

    @Override
    protected ServletServerHttpRequest createRequest(HttpServletRequest request, AsyncContext asyncContext) throws IOException, URISyntaxException {
        Assert.state(this.getServletPath() != null, "Servlet path is not initialized");
        return new TomcatServerHttpRequest(request, asyncContext, this.getServletPath(), this.getDataBufferFactory(), this.getBufferSize());
    }

    @Override
    protected ServletServerHttpResponse createResponse(HttpServletResponse response, AsyncContext asyncContext, ServletServerHttpRequest request) throws IOException {
        return new TomcatServerHttpResponse(response, asyncContext, this.getDataBufferFactory(), this.getBufferSize(), request);
    }

    private static final class TomcatServerHttpRequest
    extends ServletServerHttpRequest {
        private static final Field COYOTE_REQUEST_FIELD;
        private final int bufferSize;
        private final DataBufferFactory factory;

        TomcatServerHttpRequest(HttpServletRequest request, AsyncContext context, String servletPath, DataBufferFactory factory, int bufferSize) throws IOException, URISyntaxException {
            super(TomcatServerHttpRequest.createTomcatHttpHeaders(request), request, context, servletPath, factory, bufferSize);
            this.factory = factory;
            this.bufferSize = bufferSize;
        }

        private static MultiValueMap<String, String> createTomcatHttpHeaders(HttpServletRequest request) {
            RequestFacade requestFacade = TomcatServerHttpRequest.getRequestFacade(request);
            Request connectorRequest = (Request)ReflectionUtils.getField(COYOTE_REQUEST_FIELD, requestFacade);
            Assert.state(connectorRequest != null, "No Tomcat connector request");
            org.apache.coyote.Request tomcatRequest = connectorRequest.getCoyoteRequest();
            return new TomcatHeadersAdapter(tomcatRequest.getMimeHeaders());
        }

        private static RequestFacade getRequestFacade(HttpServletRequest request) {
            if (request instanceof RequestFacade) {
                RequestFacade facade = (RequestFacade)request;
                return facade;
            }
            if (request instanceof HttpServletRequestWrapper) {
                HttpServletRequestWrapper wrapper = (HttpServletRequestWrapper)request;
                HttpServletRequest wrappedRequest = (HttpServletRequest)wrapper.getRequest();
                return TomcatServerHttpRequest.getRequestFacade(wrappedRequest);
            }
            throw new IllegalArgumentException("Cannot convert [" + String.valueOf(request.getClass()) + "] to org.apache.catalina.connector.RequestFacade");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected DataBuffer readFromInputStream() throws IOException {
            ServletInputStream servletInputStream = this.getInputStream();
            if (servletInputStream instanceof CoyoteInputStream) {
                CoyoteInputStream coyoteInputStream = (CoyoteInputStream)servletInputStream;
                DataBuffer dataBuffer = this.factory.allocateBuffer(this.bufferSize);
                int read = -1;
                try {
                    DataBuffer dataBuffer2;
                    try (DataBuffer.ByteBufferIterator iterator = dataBuffer.writableByteBuffers();){
                        Assert.state(iterator.hasNext(), "No ByteBuffer available");
                        ByteBuffer byteBuffer = (ByteBuffer)iterator.next();
                        read = coyoteInputStream.read(byteBuffer);
                    }
                    this.logBytesRead(read);
                    if (read > 0) {
                        dataBuffer.writePosition(read);
                        dataBuffer2 = dataBuffer;
                        return dataBuffer2;
                    }
                    if (read == -1) {
                        dataBuffer2 = EOF_BUFFER;
                        return dataBuffer2;
                    }
                    dataBuffer2 = AbstractListenerReadPublisher.EMPTY_BUFFER;
                    return dataBuffer2;
                }
                finally {
                    if (read <= 0) {
                        DataBufferUtils.release(dataBuffer);
                    }
                }
            }
            return super.readFromInputStream();
        }

        static {
            Field field = ReflectionUtils.findField(RequestFacade.class, "request");
            Assert.state(field != null, "Incompatible Tomcat implementation");
            ReflectionUtils.makeAccessible(field);
            COYOTE_REQUEST_FIELD = field;
        }
    }

    private static final class TomcatServerHttpResponse
    extends ServletServerHttpResponse {
        private static final Field COYOTE_RESPONSE_FIELD;

        TomcatServerHttpResponse(HttpServletResponse response, AsyncContext context, DataBufferFactory factory, int bufferSize, ServletServerHttpRequest request) throws IOException {
            super(TomcatServerHttpResponse.createTomcatHttpHeaders(response), response, context, factory, bufferSize, request);
        }

        private static HttpHeaders createTomcatHttpHeaders(HttpServletResponse response) {
            ResponseFacade responseFacade = TomcatServerHttpResponse.getResponseFacade(response);
            org.apache.catalina.connector.Response connectorResponse = (org.apache.catalina.connector.Response)ReflectionUtils.getField(COYOTE_RESPONSE_FIELD, responseFacade);
            Assert.state(connectorResponse != null, "No Tomcat connector response");
            Response tomcatResponse = connectorResponse.getCoyoteResponse();
            TomcatHeadersAdapter headers = new TomcatHeadersAdapter(tomcatResponse.getMimeHeaders());
            return new HttpHeaders(headers);
        }

        private static ResponseFacade getResponseFacade(HttpServletResponse response) {
            if (response instanceof ResponseFacade) {
                ResponseFacade facade = (ResponseFacade)response;
                return facade;
            }
            if (response instanceof HttpServletResponseWrapper) {
                HttpServletResponseWrapper wrapper = (HttpServletResponseWrapper)response;
                HttpServletResponse wrappedResponse = (HttpServletResponse)wrapper.getResponse();
                return TomcatServerHttpResponse.getResponseFacade(wrappedResponse);
            }
            throw new IllegalArgumentException("Cannot convert [" + String.valueOf(response.getClass()) + "] to org.apache.catalina.connector.ResponseFacade");
        }

        @Override
        protected void applyHeaders() {
            this.adaptHeaders(true);
        }

        @Override
        protected int writeToOutputStream(DataBuffer dataBuffer) throws IOException {
            ServletOutputStream servletOutputStream = this.getOutputStream();
            if (servletOutputStream instanceof CoyoteOutputStream) {
                CoyoteOutputStream coyoteOutputStream = (CoyoteOutputStream)servletOutputStream;
                int len = 0;
                try (DataBuffer.ByteBufferIterator iterator = dataBuffer.readableByteBuffers();){
                    while (iterator.hasNext() && coyoteOutputStream.isReady()) {
                        ByteBuffer byteBuffer = (ByteBuffer)iterator.next();
                        len += byteBuffer.remaining();
                        coyoteOutputStream.write(byteBuffer);
                    }
                }
                return len;
            }
            return super.writeToOutputStream(dataBuffer);
        }

        static {
            Field field = ReflectionUtils.findField(ResponseFacade.class, "response");
            Assert.state(field != null, "Incompatible Tomcat implementation");
            ReflectionUtils.makeAccessible(field);
            COYOTE_RESPONSE_FIELD = field;
        }
    }
}

