/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.rocker.runtime;

import com.fizzed.rocker.ContentType;
import com.fizzed.rocker.RockerOutputFactory;
import com.fizzed.rocker.runtime.AbstractRockerOutput;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public class ArrayOfByteArraysOutput
extends AbstractRockerOutput<ArrayOfByteArraysOutput> {
    public static RockerOutputFactory<ArrayOfByteArraysOutput> FACTORY = new RockerOutputFactory<ArrayOfByteArraysOutput>(){

        @Override
        public ArrayOfByteArraysOutput create(ContentType contentType, String charsetName) {
            return new ArrayOfByteArraysOutput(contentType, charsetName);
        }
    };
    private final List<byte[]> arrays = new ArrayList<byte[]>();

    public ArrayOfByteArraysOutput(ContentType contentType, String charsetName) {
        super(contentType, charsetName, 0);
    }

    public ArrayOfByteArraysOutput(ContentType contentType, Charset charset) {
        super(contentType, charset, 0);
    }

    public List<byte[]> getArrays() {
        return this.arrays;
    }

    @Override
    public ArrayOfByteArraysOutput w(String string) throws IOException {
        byte[] bytes = string.getBytes(this.charset);
        this.arrays.add(bytes);
        this.byteLength += bytes.length;
        return this;
    }

    @Override
    public ArrayOfByteArraysOutput w(byte[] bytes) throws IOException {
        this.arrays.add(bytes);
        this.byteLength += bytes.length;
        return this;
    }

    public byte[] toByteArray() {
        byte[] bytes = new byte[this.byteLength];
        int offset = 0;
        for (byte[] chunk : this.arrays) {
            System.arraycopy(chunk, 0, bytes, offset, chunk.length);
            offset += chunk.length;
        }
        return bytes;
    }

    @Override
    public String toString() {
        byte[] bytes = this.toByteArray();
        return new String(bytes, this.charset);
    }

    public ReadableByteChannel asReadableByteChannel() {
        return new ReadableByteChannel(){
            private boolean closed = false;
            private int offset = 0;
            private final int length = ArrayOfByteArraysOutput.this.getByteLength();
            private int chunkIndex = 0;
            private int chunkOffset = 0;

            @Override
            public int read(ByteBuffer dst) throws IOException {
                if (this.closed) {
                    throw new ClosedChannelException();
                }
                if (ArrayOfByteArraysOutput.this.arrays.isEmpty() || this.offset >= this.length) {
                    return -1;
                }
                int readBytes = 0;
                while (dst.hasRemaining() && this.offset < this.length) {
                    byte[] chunk = (byte[])ArrayOfByteArraysOutput.this.arrays.get(this.chunkIndex);
                    int chunkLength = chunk.length - this.chunkOffset;
                    int capacity = dst.remaining();
                    if (capacity < chunkLength) {
                        chunkLength = capacity;
                    }
                    dst.put(chunk, this.chunkOffset, chunkLength);
                    this.offset += chunkLength;
                    this.chunkOffset += chunkLength;
                    if (this.chunkOffset >= chunk.length) {
                        ++this.chunkIndex;
                        this.chunkOffset = 0;
                    }
                    readBytes += chunkLength;
                }
                return readBytes;
            }

            @Override
            public boolean isOpen() {
                return !this.closed;
            }

            @Override
            public void close() throws IOException {
                this.closed = true;
            }
        };
    }

    public InputStream asInputStream() {
        return new ByteArrayInputStream(this.toByteArray());
    }
}

