/*
 * Decompiled with CFR 0.152.
 */
package org.grails.forge.io;

import io.micronaut.core.annotation.Nullable;
import java.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OutputUtils {
    private static final Logger LOG = LoggerFactory.getLogger(OutputUtils.class);
    private static final String ENV_SOURCE_DATE_EPOCH = "SOURCE_DATE_EPOCH";

    private OutputUtils() {
    }

    public static Instant createLastModified() {
        return OutputUtils.createLastModified(Instant.now());
    }

    @Nullable
    public static Instant createLastModified(@Nullable Instant fallback) {
        String raw = System.getenv(ENV_SOURCE_DATE_EPOCH);
        if (raw == null) {
            return fallback;
        }
        String trimmed = raw.trim();
        if (trimmed.isEmpty()) {
            LOG.warn("Environment variable {} is set but empty; using fallback.", (Object)ENV_SOURCE_DATE_EPOCH);
            return fallback;
        }
        try {
            long epochSeconds = Long.parseLong(trimmed);
            return Instant.ofEpochSecond(epochSeconds);
        }
        catch (Exception ex) {
            LOG.warn("Could not interpret {}=[{}]; using fallback. Reason: {}", ENV_SOURCE_DATE_EPOCH, raw, ex.toString());
            return fallback;
        }
    }
}

