/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.inject;

import com.google.inject.Binding;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.ProvisionException;
import com.google.inject.spi.Element;
import com.google.inject.spi.Elements;
import java.util.Map;
import java.util.logging.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Logs {
    public static final String NEW_LINE;
    private static final String SISU = "Sisu";
    private static final Sink SINK;
    public static final boolean TRACE_ENABLED;
    public static final boolean DEBUG_ENABLED;

    private Logs() {
    }

    public static void trace(String format, Object arg1, Object arg2) {
        if (TRACE_ENABLED) {
            SINK.trace(Logs.format(Logs.format(format, arg1), arg2), arg2 instanceof Throwable ? (Throwable)arg2 : null);
        }
    }

    public static void debug(String format, Object arg1, Object arg2) {
        if (DEBUG_ENABLED) {
            SINK.debug(Logs.format(Logs.format(format, arg1), arg2), arg2 instanceof Throwable ? (Throwable)arg2 : null);
        }
    }

    public static void warn(String format, Object arg1, Object arg2) {
        SINK.warn(Logs.format(Logs.format(format, arg1), arg2), arg2 instanceof Throwable ? (Throwable)arg2 : null);
    }

    public static void catchThrowable(Throwable problem) {
        for (Throwable cause = problem; cause != null; cause = cause.getCause()) {
            if (!(cause instanceof ThreadDeath) && !(cause instanceof VirtualMachineError)) continue;
            throw (Error)cause;
        }
    }

    public static void throwUnchecked(Throwable problem) {
        if (problem instanceof RuntimeException) {
            throw (RuntimeException)problem;
        }
        if (problem instanceof Error) {
            throw (Error)problem;
        }
        throw (RuntimeException)RuntimeException.class.cast(new ProvisionException(problem.toString(), problem));
    }

    public static String identityToString(Object object) {
        return null == object ? null : object.getClass().getName() + '@' + Integer.toHexString(System.identityHashCode(object));
    }

    public static String toString(Module module) {
        StringBuilder buf = new StringBuilder(Logs.identityToString(module));
        buf.append(NEW_LINE).append(NEW_LINE);
        buf.append("-----[elements]----------------------------------------------------------------").append(NEW_LINE);
        int i2 = 0;
        for (Element e : Elements.getElements((Module[])new Module[]{module})) {
            buf.append(i2++).append(". ").append(e).append(NEW_LINE);
        }
        return buf.append("-------------------------------------------------------------------------------").append(NEW_LINE).toString();
    }

    public static String toString(Injector injector) {
        StringBuilder buf = new StringBuilder(Logs.identityToString(injector));
        if (null != injector.getParent()) {
            buf.append(" parent: ").append(Logs.identityToString(injector.getParent()));
        }
        buf.append(NEW_LINE).append(NEW_LINE);
        buf.append("-----[explicit bindings]-------------------------------------------------------").append(NEW_LINE);
        int i2 = 0;
        Map explicitBindings = injector.getBindings();
        for (Binding b : explicitBindings.values()) {
            buf.append(i2++).append(". ").append(b).append(NEW_LINE);
        }
        buf.append("-----[implicit bindings]-------------------------------------------------------").append(NEW_LINE);
        for (Binding b : injector.getAllBindings().values()) {
            if (explicitBindings.containsKey(b.getKey())) continue;
            buf.append(i2++).append(". ").append(b).append(NEW_LINE);
        }
        return buf.append("-------------------------------------------------------------------------------").append(NEW_LINE).toString();
    }

    private static String format(String format, Object arg) {
        int cursor;
        int len = format.length();
        boolean detailed = true;
        int prevChar = 32;
        for (cursor = 0; cursor < len; ++cursor) {
            char currChar = format.charAt(cursor);
            if (prevChar == 123 && currChar == '}') break;
            if (prevChar == 60 && currChar == '>') {
                detailed = false;
                break;
            }
            prevChar = currChar;
        }
        if (cursor >= len) {
            return format;
        }
        StringBuilder buf = new StringBuilder();
        if (--cursor > 0) {
            buf.append(format.substring(0, cursor));
        }
        try {
            buf.append(detailed ? arg : Logs.identityToString(arg));
        }
        catch (RuntimeException e) {
            buf.append(e);
        }
        if ((cursor += 2) < len) {
            buf.append(format.substring(cursor, len));
        }
        return buf.toString();
    }

    static {
        Sink sink;
        boolean toConsole;
        String newLine;
        try {
            newLine = System.getProperty("line.separator", "\n");
            String debug = System.getProperty("sisu.debug", "false");
            toConsole = "".equals(debug) || "true".equalsIgnoreCase(debug);
        }
        catch (RuntimeException e) {
            newLine = "\n";
            toConsole = false;
        }
        NEW_LINE = newLine;
        try {
            sink = toConsole ? new ConsoleSink() : new SLF4JSink();
        }
        catch (RuntimeException e) {
            sink = new JULSink();
        }
        catch (LinkageError e) {
            sink = new JULSink();
        }
        SINK = sink;
        TRACE_ENABLED = SINK.isTraceEnabled();
        DEBUG_ENABLED = SINK.isDebugEnabled();
    }

    private static interface Sink {
        public boolean isTraceEnabled();

        public boolean isDebugEnabled();

        public void trace(String var1, Throwable var2);

        public void debug(String var1, Throwable var2);

        public void warn(String var1, Throwable var2);
    }

    static final class ConsoleSink
    implements Sink {
        private static final String TRACE = "TRACE: Sisu - ";
        private static final String DEBUG = "DEBUG: Sisu - ";
        private static final String WARN = "WARN: Sisu - ";

        ConsoleSink() {
        }

        @Override
        public boolean isTraceEnabled() {
            return true;
        }

        @Override
        public boolean isDebugEnabled() {
            return true;
        }

        @Override
        public void trace(String message, Throwable cause) {
            System.out.println(TRACE + message);
            if (null != cause) {
                cause.printStackTrace(System.out);
            }
        }

        @Override
        public void debug(String message, Throwable cause) {
            System.out.println(DEBUG + message);
            if (null != cause) {
                cause.printStackTrace(System.out);
            }
        }

        @Override
        public void warn(String message, Throwable cause) {
            System.err.println(WARN + message);
            if (null != cause) {
                cause.printStackTrace(System.err);
            }
        }
    }

    static final class SLF4JSink
    implements Sink {
        private static final Logger logger = LoggerFactory.getLogger("Sisu");

        SLF4JSink() {
        }

        @Override
        public boolean isTraceEnabled() {
            return logger.isTraceEnabled();
        }

        @Override
        public boolean isDebugEnabled() {
            return logger.isDebugEnabled();
        }

        @Override
        public void trace(String message, Throwable cause) {
            logger.trace(message, cause);
        }

        @Override
        public void debug(String message, Throwable cause) {
            logger.debug(message, cause);
        }

        @Override
        public void warn(String message, Throwable cause) {
            logger.warn(message, cause);
        }
    }

    static final class JULSink
    implements Sink {
        private static final java.util.logging.Logger logger = java.util.logging.Logger.getLogger("Sisu");

        JULSink() {
        }

        @Override
        public boolean isTraceEnabled() {
            return logger.isLoggable(Level.FINER);
        }

        @Override
        public boolean isDebugEnabled() {
            return logger.isLoggable(Level.FINE);
        }

        @Override
        public void trace(String message, Throwable cause) {
            logger.log(Level.FINER, message, cause);
        }

        @Override
        public void debug(String message, Throwable cause) {
            logger.log(Level.FINE, message, cause);
        }

        @Override
        public void warn(String message, Throwable cause) {
            logger.log(Level.WARNING, message, cause);
        }
    }
}

